/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.rename;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.refactoring.core.rename.AbstractRenameProcessor;
import org.eclipse.php.refactoring.core.rename.INameUpdating;
import org.eclipse.php.refactoring.core.rename.ITextUpdating;
import org.eclipse.php.refactoring.core.rename.RenameClassMemberProcessor;
import org.eclipse.php.refactoring.core.rename.RenameClassProcessor;
import org.eclipse.php.refactoring.core.rename.RenameFileProcessor;
import org.eclipse.php.refactoring.core.rename.RenameFolderProcessor;
import org.eclipse.php.refactoring.core.rename.RenameFunctionProcessor;
import org.eclipse.php.refactoring.core.rename.RenameGlobalConstantProcessor;
import org.eclipse.php.refactoring.core.rename.RenameGlobalVariableProcessor;
import org.eclipse.php.refactoring.core.rename.RenameLocalVariableProcessor;
import org.eclipse.php.refactoring.core.rename.RenameTraitProcessor;
import org.eclipse.php.refactoring.ui.PHPRefactoringUIMessages;
import org.eclipse.php.refactoring.ui.rename.RenameUserInterfaceManager;
import org.eclipse.php.refactoring.ui.rename.UserInterfaceStarter;
import org.eclipse.swt.widgets.Shell;

public class RenameSupport {
    private RenameRefactoring fRefactoring;
    private RefactoringStatus fPreCheckStatus;
    public static final int NONE = 0;
    public static final int UPDATE_REFERENCES = 1;
    public static final int UPDATE_TEXTUAL_MATCHES = 64;
    public static final int UPDATE_GETTER_METHOD = 16;
    public static final int UPDATE_SETTER_METHOD = 32;

    public IStatus preCheck() throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            return this.fPreCheckStatus.getEntryMatchingSeverity(4).toStatus();
        }
        return new Status(0, "org.eclipse.php.refactoring.ui", 0, "", null);
    }

    public boolean openDialog(Shell parent) throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            this.showInformation(parent, this.fPreCheckStatus);
            return false;
        }
        UserInterfaceStarter starter = RenameUserInterfaceManager.getDefault().getStarter((Refactoring)this.fRefactoring);
        return starter.activate((Refactoring)this.fRefactoring, parent, true);
    }

    public void perform(Shell parent, IRunnableContext context) throws InterruptedException, InvocationTargetException {
        try {
            this.ensureChecked();
            if (this.fPreCheckStatus.hasFatalError()) {
                this.showInformation(parent, this.fPreCheckStatus);
                return;
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        RefactoringExecutionHelper helper = new RefactoringExecutionHelper((Refactoring)this.fRefactoring, RefactoringCore.getConditionCheckingFailedSeverity(), false, parent, context);
        helper.perform(false);
    }

    private RenameSupport(AbstractRenameProcessor<?> processor, String newName, int flags) throws CoreException {
        this.fRefactoring = new RenameRefactoring(processor);
        RenameSupport.initialize(this.fRefactoring, newName, flags);
    }

    public static RenameSupport create(IResource operatedFile, int element, ASTNode locateNode, String newName, int flags) throws CoreException {
        RenameFolderProcessor processor = null;
        if (operatedFile instanceof IContainer) {
            processor = new RenameFolderProcessor((IContainer)operatedFile);
        } else {
            switch (element) {
                case 1: {
                    processor = new RenameGlobalVariableProcessor((IFile)operatedFile, locateNode);
                    break;
                }
                case 2: {
                    processor = new RenameFunctionProcessor((IFile)operatedFile, locateNode);
                    break;
                }
                case 3: {
                    processor = new RenameLocalVariableProcessor((IFile)operatedFile, locateNode);
                    break;
                }
                case 4: {
                    processor = new RenameClassProcessor((IFile)operatedFile, locateNode);
                    break;
                }
                case 8: {
                    processor = new RenameTraitProcessor((IFile)operatedFile, locateNode);
                    break;
                }
                case 5: {
                    processor = new RenameGlobalConstantProcessor((IFile)operatedFile, locateNode);
                    break;
                }
                case 6: {
                    processor = new RenameClassMemberProcessor((IFile)operatedFile, locateNode);
                    break;
                }
                case 7: {
                    processor = new RenameFileProcessor(operatedFile, (Program)locateNode);
                }
            }
        }
        return processor == null ? null : new RenameSupport((AbstractRenameProcessor<?>)processor, newName, flags);
    }

    private static void initialize(RenameRefactoring refactoring, String newName, int flags) {
        if (refactoring.getProcessor() == null) {
            return;
        }
        RenameSupport.setNewName((INameUpdating)refactoring.getAdapter(INameUpdating.class), newName);
        ITextUpdating text = (ITextUpdating)refactoring.getAdapter(ITextUpdating.class);
        if (text != null) {
            text.setUpdateTextualMatches(RenameSupport.updateTextualMatches(flags));
        }
    }

    private static void setNewName(INameUpdating refactoring, String newName) {
        if (newName != null) {
            refactoring.setNewElementName(newName);
        }
    }

    private static boolean updateTextualMatches(int flags) {
        int TEXT_UPDATES = 64;
        return (flags & TEXT_UPDATES) != 0;
    }

    private void ensureChecked() throws CoreException {
        if (this.fPreCheckStatus == null) {
            this.fPreCheckStatus = !this.fRefactoring.isApplicable() ? RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringUIMessages.getString("RenameSupport_not_available")) : new RefactoringStatus();
        }
    }

    private void showInformation(Shell parent, RefactoringStatus status) {
        String message = status.getMessageMatchingSeverity(4);
        MessageDialog.openInformation((Shell)parent, (String)PHPRefactoringUIMessages.getString("RenameSupport_dialog_title"), (String)message);
    }
}

