/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.editor.actions;

import java.util.Comparator;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.CommandAction;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.uml2.common.edit.command.ChangeCommand;
import org.eclipse.uml2.common.edit.provider.IItemQualifiedTextProvider;
import org.eclipse.uml2.uml.editor.presentation.UMLEditor;

public class UMLCommandAction
extends CommandAction {
    private ILabelProvider labelProvider = null;

    protected UMLCommandAction() {
    }

    protected ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    protected AdapterFactory getAdapterFactory() {
        return this.workbenchPart instanceof UMLEditor ? ((UMLEditor)this.workbenchPart).getAdapterFactory() : null;
    }

    public void setActiveEditor(IAction action, IEditorPart editorPart) {
        super.setActiveEditor(action, editorPart);
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        this.labelProvider = editorPart == null ? null : new AdapterFactoryLabelProvider(this.getAdapterFactory()){

            public String getColumnText(Object object, int columnIndex) {
                String lastSegment;
                Resource eResource;
                String columnText;
                IItemQualifiedTextProvider itemQualifiedTextProvider = (IItemQualifiedTextProvider)this.adapterFactory.adapt(object, IItemQualifiedTextProvider.class);
                String string = columnText = itemQualifiedTextProvider != null ? itemQualifiedTextProvider.getQualifiedText(object) : super.getColumnText(object, columnIndex);
                if (object instanceof EObject && (eResource = ((EObject)object).eResource()) != null && (lastSegment = eResource.getURI().lastSegment()) != null) {
                    columnText = String.valueOf(columnText) + " - " + lastSegment;
                }
                return columnText;
            }

            public String getText(Object object) {
                String lastSegment;
                Resource eResource;
                String text;
                IItemQualifiedTextProvider itemQualifiedTextProvider = (IItemQualifiedTextProvider)this.adapterFactory.adapt(object, IItemQualifiedTextProvider.class);
                String string = text = itemQualifiedTextProvider != null ? itemQualifiedTextProvider.getQualifiedText(object) : super.getText(object);
                if (object instanceof EObject && (eResource = ((EObject)object).eResource()) != null && (lastSegment = eResource.getURI().lastSegment()) != null) {
                    text = String.valueOf(text) + " - " + lastSegment;
                }
                return text;
            }
        };
    }

    protected void refreshViewer() {
        if (this.workbenchPart instanceof IViewerProvider) {
            ((IViewerProvider)this.workbenchPart).getViewer().refresh();
        }
    }

    protected class RefreshingChangeCommand
    extends ChangeCommand {
        public RefreshingChangeCommand(EditingDomain editingDomain, Runnable runnable, String label) {
            super(editingDomain, runnable, label);
        }

        public void execute() {
            super.execute();
            UMLCommandAction.this.refreshViewer();
        }

        public void undo() {
            super.undo();
            UMLCommandAction.this.refreshViewer();
        }

        public void redo() {
            super.redo();
            UMLCommandAction.this.refreshViewer();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TextComparator<T>
    implements Comparator<T> {
        protected TextComparator() {
        }

        @Override
        public int compare(T t1, T t2) {
            return CommonPlugin.INSTANCE.getComparator().compare(UMLCommandAction.this.getLabelProvider().getText(t1), UMLCommandAction.this.getLabelProvider().getText(t2));
        }
    }
}

