/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.impl;

import com.google.gwt.editor.client.CompositeEditor;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.HasEditorDelegate;
import com.google.gwt.editor.client.HasEditorErrors;
import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.client.ValueAwareEditor;
import com.google.gwt.editor.client.impl.DelegateMap;
import com.google.gwt.editor.client.impl.SimpleError;
import com.google.gwt.event.shared.HandlerRegistration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEditorDelegate<T, E extends Editor<T>>
implements EditorDelegate<T> {
    protected CompositeEditor<T, Object, Editor<Object>> composedEditor;
    protected Chain<Object, Editor<Object>> editorChain;
    protected List<EditorError> errors;
    protected HasEditorErrors<T> hasEditorErrors;
    protected LeafValueEditor<T> leafValueEditor;
    protected String path;
    protected Map<String, Editor<?>> simpleEditors;
    protected ValueAwareEditor<T> valueAwareEditor;

    protected static String appendPath(String prefix, String path) {
        if ("".equals(prefix)) {
            return path;
        }
        return prefix + "." + path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(List<EditorError> errorAccumulator) {
        try {
            if (this.valueAwareEditor != null) {
                this.valueAwareEditor.flush();
            }
            if (this.leafValueEditor != null) {
                this.setObject(this.leafValueEditor.getValue());
                return;
            }
            if (this.getObject() == null) {
                return;
            }
            this.flushSubEditors(this.errors);
            if (this.editorChain != null) {
                this.editorChain.collectErrors();
            }
        }
        finally {
            this.showErrors(errorAccumulator);
        }
    }

    public void flushErrors(List<EditorError> errorAccumulator) {
        this.flushSubEditorErrors(errorAccumulator);
        this.showErrors(errorAccumulator);
    }

    public abstract T getObject();

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void recordError(String message, Object value, Object userData) {
        SimpleError error = new SimpleError(this, message, value, userData);
        this.errors.add(error);
    }

    public void recordError(String message, Object value, Object userData, String extraPath) {
        SimpleError error = new SimpleError(this, message, value, userData, extraPath);
        this.errors.add(error);
    }

    public void refresh(T object) {
        this.setObject(this.ensureMutable(object));
        if (this.leafValueEditor != null) {
            this.leafValueEditor.setValue(object);
        } else if (this.valueAwareEditor != null) {
            this.valueAwareEditor.setValue(object);
        }
        this.refreshEditors();
    }

    @Override
    public abstract HandlerRegistration subscribe();

    protected String appendPath(String path) {
        return AbstractEditorDelegate.appendPath(this.path, path);
    }

    protected abstract void attachSubEditors(DelegateMap var1);

    protected <C, D extends Editor<C>> AbstractEditorDelegate<C, D> createComposedDelegate() {
        throw new IllegalStateException();
    }

    protected <Q> Q ensureMutable(Q object) {
        return object;
    }

    protected abstract void flushSubEditorErrors(List<EditorError> var1);

    protected abstract void flushSubEditors(List<EditorError> var1);

    protected abstract E getEditor();

    protected Editor<?> getSimpleEditor(String declaredPath) {
        return this.simpleEditors.get(declaredPath);
    }

    protected void initialize(String pathSoFar, T object, E editor, DelegateMap map) {
        this.path = pathSoFar;
        this.setEditor(editor);
        this.setObject(this.ensureMutable(object));
        this.errors = new ArrayList<EditorError>();
        this.simpleEditors = new HashMap();
        if (editor instanceof HasEditorErrors) {
            this.hasEditorErrors = (HasEditorErrors)editor;
        }
        if (editor instanceof LeafValueEditor) {
            this.leafValueEditor = (LeafValueEditor)editor;
        }
        if (editor instanceof HasEditorDelegate) {
            ((HasEditorDelegate)editor).setDelegate(this);
        }
        if (editor instanceof ValueAwareEditor) {
            this.valueAwareEditor = (ValueAwareEditor)editor;
            if (editor instanceof CompositeEditor) {
                CompositeEditor temp;
                this.composedEditor = temp = (CompositeEditor)editor;
                this.editorChain = new Chain(map);
                this.composedEditor.setEditorChain(this.editorChain);
            }
        }
        if (this.leafValueEditor != null) {
            this.leafValueEditor.setValue(object);
            return;
        }
        if (this.valueAwareEditor != null) {
            this.valueAwareEditor.setValue(object);
        }
        if (object != null) {
            this.attachSubEditors(map);
        }
    }

    protected abstract <R, S extends Editor<R>> void initializeSubDelegate(AbstractEditorDelegate<R, S> var1, String var2, R var3, S var4, DelegateMap var5);

    protected abstract void refreshEditors();

    protected abstract void setEditor(E var1);

    protected abstract void setObject(T var1);

    protected boolean shouldFlush() {
        return true;
    }

    protected abstract void traverse(List<String> var1);

    private void showErrors(List<EditorError> errorAccumulator) {
        assert (this.errors != errorAccumulator);
        if (this.hasEditorErrors != null) {
            Iterator<EditorError> it = errorAccumulator.iterator();
            while (it.hasNext()) {
                EditorError error = it.next();
                if (!error.getAbsolutePath().startsWith(this.getPath())) continue;
                this.errors.add(error);
                it.remove();
            }
            int length = this.getPath().length();
            int pathPrefixLength = length == 0 ? 0 : length + 1;
            for (EditorError error : this.errors) {
                ((SimpleError)error).setPathPrefixLength(pathPrefixLength);
            }
            this.hasEditorErrors.showErrors(Collections.unmodifiableList(this.errors));
            for (EditorError error : this.errors) {
                if (error.isConsumed()) continue;
                errorAccumulator.add(error);
            }
            this.errors = new ArrayList<EditorError>();
        } else {
            errorAccumulator.addAll(this.errors);
            this.errors.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Chain<R, S extends Editor<R>>
    implements CompositeEditor.EditorChain<R, S> {
        private DelegateMap delegateMap;
        private Map<S, AbstractEditorDelegate<R, S>> map = new LinkedHashMap<S, AbstractEditorDelegate<R, S>>();

        public Chain(DelegateMap delegateMap) {
            this.delegateMap = delegateMap;
        }

        @Override
        public void attach(R object, S subEditor) {
            AbstractEditorDelegate<Object, Object> subDelegate = this.map.get(subEditor);
            S temp = subEditor;
            String subPath = AbstractEditorDelegate.this.path + AbstractEditorDelegate.this.composedEditor.getPathElement((Editor<Object>)temp);
            if (subDelegate == null) {
                subDelegate = AbstractEditorDelegate.this.createComposedDelegate();
                this.map.put(subEditor, subDelegate);
                AbstractEditorDelegate.this.initializeSubDelegate(subDelegate, subPath, object, subEditor, this.delegateMap);
            } else {
                subDelegate.path = subPath;
                subDelegate.refresh(object);
            }
        }

        @Override
        public void detach(S subEditor) {
            AbstractEditorDelegate<R, S> subDelegate = this.map.remove(subEditor);
            if (subDelegate != null && subDelegate.shouldFlush()) {
                subDelegate.flush(AbstractEditorDelegate.this.errors);
            }
        }

        @Override
        public R getValue(S subEditor) {
            AbstractEditorDelegate<R, S> subDelegate = this.map.get(subEditor);
            if (subDelegate == null) {
                return null;
            }
            if (subDelegate.shouldFlush()) {
                subDelegate.flush(AbstractEditorDelegate.this.errors);
            }
            return subDelegate.getObject();
        }

        void collectErrors() {
            for (AbstractEditorDelegate<R, S> delegate : this.map.values()) {
                AbstractEditorDelegate.this.errors.addAll(delegate.errors);
                delegate.errors.clear();
            }
        }
    }
}

