/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.ConsulterSupplyFunction;
import io.github.toolfactory.jvm.function.template.ThrowingBiFunction;
import io.github.toolfactory.jvm.util.ObjectProvider;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;

public interface ConstructorInvokeFunction
extends ThrowingBiFunction<Constructor<?>, Object[], Object, Throwable> {

    public static class ForJava22
    extends ForJava9 {
        public ForJava22(Map<Object, Object> context) throws Throwable {
            super(context);
        }

        @Override
        protected String retrieveNativeAccessorClassName() {
            return "jdk.internal.reflect.DirectConstructorHandleAccessor$NativeAccessor";
        }
    }

    public static class ForJava9
    extends Abst {
        public ForJava9(Map<Object, Object> context) throws Throwable {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            Class<?> accessorImplClass = Class.forName(this.retrieveNativeAccessorClassName());
            Method method = accessorImplClass.getDeclaredMethod("newInstance0", Constructor.class, Object[].class);
            ConsulterSupplyFunction getConsulterFunction = functionProvider.getOrBuildObject(ConsulterSupplyFunction.class, context);
            MethodHandles.Lookup consulter = (MethodHandles.Lookup)getConsulterFunction.apply(accessorImplClass);
            this.methodHandle = consulter.unreflect(method);
        }

        protected String retrieveNativeAccessorClassName() {
            return "jdk.internal.reflect.NativeConstructorAccessorImpl";
        }
    }

    public static class ForJava7
    extends Abst {
        public ForJava7(Map<Object, Object> context) throws Throwable {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            Class<?> accessorImplClass = Class.forName("sun.reflect.NativeConstructorAccessorImpl");
            Method method = accessorImplClass.getDeclaredMethod("newInstance0", Constructor.class, Object[].class);
            ConsulterSupplyFunction getConsulterFunction = functionProvider.getOrBuildObject(ConsulterSupplyFunction.class, context);
            MethodHandles.Lookup consulter = (MethodHandles.Lookup)getConsulterFunction.apply(accessorImplClass);
            method.setAccessible(true);
            this.methodHandle = consulter.unreflect(method);
        }
    }

    public static abstract class Abst
    implements ConstructorInvokeFunction {
        protected MethodHandle methodHandle;

        @Override
        public Object apply(Constructor<?> ctor, Object[] params) throws Throwable {
            return this.methodHandle.invokeWithArguments(ctor, params);
        }
    }
}

