/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.ws.spi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

class FactoryFinder {
    private static final boolean debug = false;

    FactoryFinder() {
    }

    private static void debugPrintln(String msg) {
    }

    private static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader cl = (ClassLoader)FactoryFinder.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method m = null;
                try {
                    m = Thread.class.getMethod("getContextClassLoader", null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    FactoryFinder.debugPrintln("assuming JDK 1.1");
                    return FactoryFinder.class.getClassLoader();
                }
                try {
                    return (ClassLoader)m.invoke((Object)Thread.currentThread(), null);
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationError("Unexpected IllegalAccessException", e);
                }
                catch (InvocationTargetException e) {
                    throw new ConfigurationError("Unexpected InvocationTargetException", e);
                }
            }
        });
        return cl;
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ConfigurationError {
        final ClassLoader iClassLoader = classLoader;
        final String iClassName = className;
        Object obj = FactoryFinder.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    if (iClassLoader != null) {
                        try {
                            return iClassLoader.loadClass(iClassName).newInstance();
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                    return Class.forName(iClassName).newInstance();
                }
                catch (ClassNotFoundException x) {
                    throw new ConfigurationError("Provider " + iClassName + " not found", x);
                }
                catch (Exception x) {
                    throw new ConfigurationError("Provider " + iClassName + " could not be instantiated: " + x, x);
                }
            }
        });
        return obj;
    }

    static Object find(String factoryId, String fallbackClassName) throws ConfigurationError {
        final String iFactoryId = factoryId;
        final String iFallbackClassName = fallbackClassName;
        Object obj = FactoryFinder.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader;
                block12: {
                    FactoryFinder.debugPrintln("debug is on");
                    classLoader = FactoryFinder.findClassLoader();
                    try {
                        String systemProp = System.getProperty(iFactoryId);
                        if (systemProp != null) {
                            FactoryFinder.debugPrintln("found system property " + systemProp);
                            return FactoryFinder.newInstance(systemProp, classLoader);
                        }
                    }
                    catch (SecurityException securityException) {}
                    try {
                        String javah = System.getProperty("java.home");
                        String configFile = String.valueOf(javah) + File.separator + "lib" + File.separator + "jaxrpc.properties";
                        File f = new File(configFile);
                        if (f.exists()) {
                            Properties props = new Properties();
                            props.load(new FileInputStream(f));
                            String factoryClassName = props.getProperty(iFactoryId);
                            FactoryFinder.debugPrintln("found java.home property " + factoryClassName);
                            return FactoryFinder.newInstance(factoryClassName, classLoader);
                        }
                    }
                    catch (Exception exception) {}
                    String serviceId = "META-INF/services/" + iFactoryId;
                    try {
                        BufferedReader rd;
                        InputStream is = null;
                        is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
                        if (is == null) break block12;
                        FactoryFinder.debugPrintln("found " + serviceId);
                        try {
                            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            rd = new BufferedReader(new InputStreamReader(is));
                        }
                        String factoryClassName = rd.readLine();
                        rd.close();
                        if (factoryClassName != null && !"".equals(factoryClassName)) {
                            FactoryFinder.debugPrintln("loaded from services: " + factoryClassName);
                            return FactoryFinder.newInstance(factoryClassName, classLoader);
                        }
                    }
                    catch (Exception exception) {}
                }
                if (iFallbackClassName == null) {
                    throw new ConfigurationError("Provider for " + iFactoryId + " cannot be found", null);
                }
                FactoryFinder.debugPrintln("loaded from fallback value: " + iFallbackClassName);
                return FactoryFinder.newInstance(iFallbackClassName, classLoader);
            }
        });
        return obj;
    }

    private static Object doPrivileged(PrivilegedAction action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return action.run();
        }
        return AccessController.doPrivileged(action);
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

