/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassLoaderUtils;

class ServiceLoaderRegistry {
    ServiceLoaderRegistry() {
    }

    static <T> Iterable<T> load(Class<T> serviceProviderClass) {
        ServiceLoader listeners = ServiceLoader.load(serviceProviderClass, ClassLoaderUtils.getDefaultClassLoader());
        ServiceLoaderRegistry.getLogger().config(() -> "Loaded " + serviceProviderClass.getSimpleName() + " instances: " + StreamSupport.stream(listeners.spliterator(), false).map(Object::toString).collect(Collectors.toList()));
        return listeners;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ServiceLoaderRegistry.class);
    }
}

