/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.HitsThresholdChecker;
import org.apache.lucene.search.MaxScoreAccumulator;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;

public class TopScoreDocCollectorManager
implements CollectorManager<TopScoreDocCollector, TopDocs> {
    private final int numHits;
    private final ScoreDoc after;
    private final HitsThresholdChecker hitsThresholdChecker;
    private final MaxScoreAccumulator minScoreAcc;
    private final boolean supportsConcurrency;
    private boolean collectorCreated;

    public TopScoreDocCollectorManager(int numHits, ScoreDoc after, int totalHitsThreshold, boolean supportsConcurrency) {
        if (totalHitsThreshold < 0) {
            throw new IllegalArgumentException("totalHitsThreshold must be >= 0, got " + totalHitsThreshold);
        }
        if (numHits <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollectorManager if you just need the total hit count");
        }
        this.numHits = numHits;
        this.after = after;
        this.supportsConcurrency = supportsConcurrency;
        this.hitsThresholdChecker = supportsConcurrency ? HitsThresholdChecker.createShared(Math.max(totalHitsThreshold, numHits)) : HitsThresholdChecker.create(Math.max(totalHitsThreshold, numHits));
        this.minScoreAcc = supportsConcurrency ? new MaxScoreAccumulator() : null;
    }

    public TopScoreDocCollectorManager(int numHits, ScoreDoc after, int totalHitsThreshold) {
        this(numHits, after, totalHitsThreshold, true);
    }

    public TopScoreDocCollectorManager(int numHits, int totalHitsThreshold) {
        this(numHits, null, totalHitsThreshold, true);
    }

    @Override
    public TopScoreDocCollector newCollector() {
        if (this.collectorCreated && !this.supportsConcurrency) {
            throw new IllegalStateException("This TopScoreDocCollectorManager was created without concurrency (supportsConcurrency=false), but multiple collectors are being created");
        }
        this.collectorCreated = true;
        if (this.after == null) {
            return new TopScoreDocCollector.SimpleTopScoreDocCollector(this.numHits, this.hitsThresholdChecker, this.minScoreAcc);
        }
        return new TopScoreDocCollector.PagingTopScoreDocCollector(this.numHits, this.after, this.hitsThresholdChecker, this.minScoreAcc);
    }

    @Override
    public TopDocs reduce(Collection<TopScoreDocCollector> collectors) throws IOException {
        TopDocs[] topDocs = new TopDocs[collectors.size()];
        int i = 0;
        for (TopScoreDocCollector collector : collectors) {
            topDocs[i++] = collector.topDocs();
        }
        return TopDocs.merge(0, this.numHits, topDocs);
    }
}

