/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesSearchQuery;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class ReferencesSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private ReferencesSearchQuery query;

    public ReferencesSearchResult(ReferencesSearchQuery query) {
        this.query = query;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public ImageDescriptor getImageDescriptor() {
        return AcceleoUIActivator.getImageDescriptor("icons/AcceleoEditor.gif");
    }

    public String getLabel() {
        int matchCount = this.getMatchCount();
        EObject declaration = this.query.getDeclaration();
        return AcceleoUIMessages.getString("AcceleoReferencesSearch.Result.Label", declaration, matchCount);
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public String getTooltip() {
        return AcceleoUIMessages.getString("AcceleoReferencesSearch.Result.Tooltip");
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IFile file = null;
        if (editor.getEditorInput() instanceof IFileEditorInput) {
            file = ((IFileEditorInput)editor.getEditorInput()).getFile();
        }
        return result.getMatches(file);
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        if (editor instanceof AcceleoEditor && ((AcceleoEditor)editor).getFile() != null && match.getElement() instanceof IFile) {
            IFile matchedFile = (IFile)match.getElement();
            return ((AcceleoEditor)editor).getFile().equals((Object)matchedFile);
        }
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return result.getMatches((Object)file);
    }

    public IFile getFile(Object element) {
        if (element instanceof IFile) {
            return (IFile)element;
        }
        return null;
    }

    public void removeAll() {
        Object[] elements;
        Object[] objectArray = elements = this.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ReferenceEntry) {
                ReferenceEntry entry = (ReferenceEntry)object;
                this.removeMarker(entry);
            }
            ++n2;
        }
        super.removeAll();
    }

    public void removeMatch(Match match) {
        Object element = match.getElement();
        if (element instanceof ReferenceEntry) {
            ReferenceEntry entry = (ReferenceEntry)element;
            this.removeMarker(entry);
        }
        super.removeMatch(match);
    }

    public void removeMatches(Match[] matches) {
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            Object element = match.getElement();
            if (element instanceof ReferenceEntry) {
                ReferenceEntry entry = (ReferenceEntry)element;
                this.removeMarker(entry);
            }
            ++n2;
        }
        super.removeMatches(matches);
    }

    private void removeMarker(ReferenceEntry entry) {
        IFile file = entry.getTemplateFile();
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = file.findMarkers("org.eclipse.search.searchmarker", false, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker iMarker = iMarkerArray[n2];
                int charStart = MarkerUtilities.getCharStart((IMarker)iMarker);
                int charEnd = MarkerUtilities.getCharEnd((IMarker)iMarker);
                if (charStart == entry.getRegion().getOffset() && charEnd == entry.getRegion().getOffset() + entry.getRegion().getLength()) {
                    iMarker.delete();
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
    }
}

