/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.rules;

import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.ISequenceRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class FirstParenthesisRule
implements ISequenceRule {
    private static final String ANY_WORD = "*";
    private String blockType;
    private final IToken token;

    public FirstParenthesisRule(String blockType, IToken token) {
        this.blockType = blockType;
        this.token = token;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (this.read(scanner) > 0) {
            return this.token;
        }
        return Token.UNDEFINED;
    }

    @Override
    public int read(ICharacterScanner scanner) {
        int c = scanner.read();
        scanner.unread();
        int shift = 1;
        if (c == 40 && this.validateLocation(scanner)) {
            scanner.read();
        } else {
            --shift;
        }
        return shift;
    }

    private boolean validateLocation(ICharacterScanner scanner) {
        boolean valid = true;
        int shift = 0;
        int n = this.unreadPreviousWord(scanner, ANY_WORD);
        if (n == 0) {
            valid = false;
        } else {
            shift += n;
        }
        if (valid) {
            n = this.unreadVisibility(scanner);
            shift += n;
            n = this.unreadPreviousWord(scanner, this.blockType);
            if (n == 0) {
                valid = false;
            } else {
                shift += n;
            }
        }
        while (shift < 0) {
            scanner.read();
            ++shift;
        }
        return valid;
    }

    private int unreadVisibility(ICharacterScanner scanner) {
        int c;
        int shift = 0;
        do {
            c = this.unreadChar(scanner);
            --shift;
        } while (Character.isWhitespace(c));
        String word = "";
        while (c != -1 && Character.isJavaIdentifierPart(c)) {
            word = String.valueOf(Character.toString((char)c)) + word;
            c = this.unreadChar(scanner);
            --shift;
        }
        if (!("public".equals(word) || "protected".equals(word) || "private".equals(word))) {
            while (shift < 0) {
                scanner.read();
                ++shift;
            }
        }
        return shift;
    }

    private int unreadPreviousWord(ICharacterScanner scanner, String previousWord) {
        assert (previousWord.length() > 0);
        boolean valid = false;
        int shift = 0;
        if (scanner.getColumn() >= previousWord.length()) {
            int c;
            do {
                c = this.unreadChar(scanner);
                --shift;
            } while (Character.isWhitespace(c));
            if (ANY_WORD.equals(previousWord)) {
                while (Character.isJavaIdentifierPart(c) && scanner.getColumn() > 0) {
                    valid = true;
                    c = this.unreadChar(scanner);
                    --shift;
                }
            } else if (scanner.getColumn() >= previousWord.length() - 1) {
                valid = true;
                int i = previousWord.length() - 1;
                while (valid && i >= 0) {
                    if (previousWord.charAt(i) != c) {
                        valid = false;
                    } else if (i > 0) {
                        c = this.unreadChar(scanner);
                        --shift;
                    }
                    --i;
                }
            }
        }
        if (!valid) {
            while (shift < 0) {
                scanner.read();
                ++shift;
            }
        }
        return shift;
    }

    private int unreadChar(ICharacterScanner scanner) {
        scanner.unread();
        int c = scanner.read();
        scanner.unread();
        return c;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }
}

