/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.buildship.core.GradleDistribution;

public final class BuildConfiguration {
    private final File rootProjectDirectory;
    private final boolean overrideWorkspaceConfiguration;
    private final GradleDistribution gradleDistribution;
    private final File gradleUserHome;
    private final File javaHome;
    private final boolean buildScansEnabled;
    private final boolean offlineMode;
    private final boolean autoSync;
    private final List<String> arguments;
    private final List<String> jvmArguments;
    private final boolean showConsoleView;
    private final boolean showExecutionsView;

    private BuildConfiguration(BuildConfigurationBuilder builder) {
        this.rootProjectDirectory = (File)Preconditions.checkNotNull((Object)builder.rootProjectDirectory);
        this.overrideWorkspaceConfiguration = builder.overrideWorkspaceConfiguration;
        this.gradleDistribution = builder.gradleDistribution == null ? GradleDistribution.fromBuild() : builder.gradleDistribution;
        this.gradleUserHome = builder.gradleUserHome;
        this.javaHome = builder.javaHome;
        this.buildScansEnabled = builder.buildScansEnabled;
        this.offlineMode = builder.offlineMode;
        this.autoSync = builder.autoSync;
        this.arguments = builder.arguments == null ? Collections.emptyList() : builder.arguments;
        this.jvmArguments = builder.jvmArguments == null ? Collections.emptyList() : builder.jvmArguments;
        this.showConsoleView = builder.showConsoleView;
        this.showExecutionsView = builder.showExecutionsView;
    }

    public static BuildConfigurationBuilder forRootProjectDirectory(File rootProjectDirectory) {
        return new BuildConfigurationBuilder(rootProjectDirectory);
    }

    public boolean isOverrideWorkspaceConfiguration() {
        return this.overrideWorkspaceConfiguration;
    }

    public File getRootProjectDirectory() {
        return this.rootProjectDirectory;
    }

    public Optional<File> getGradleUserHome() {
        return Optional.ofNullable(this.gradleUserHome);
    }

    public Optional<File> getJavaHome() {
        return Optional.ofNullable(this.javaHome);
    }

    public boolean isBuildScansEnabled() {
        return this.buildScansEnabled;
    }

    public boolean isOfflineMode() {
        return this.offlineMode;
    }

    public boolean isAutoSync() {
        return this.autoSync;
    }

    public GradleDistribution getGradleDistribution() {
        return this.gradleDistribution;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public List<String> getJvmArguments() {
        return this.jvmArguments;
    }

    public boolean isShowConsoleView() {
        return this.showConsoleView;
    }

    public boolean isShowExecutionsView() {
        return this.showExecutionsView;
    }

    public static final class BuildConfigurationBuilder {
        private final File rootProjectDirectory;
        private boolean overrideWorkspaceConfiguration = false;
        private GradleDistribution gradleDistribution;
        private File gradleUserHome = null;
        private File javaHome = null;
        private boolean buildScansEnabled = false;
        private boolean offlineMode = false;
        private boolean autoSync = false;
        private List<String> arguments = new ArrayList<String>();
        private List<String> jvmArguments = new ArrayList<String>();
        private boolean showConsoleView = true;
        private boolean showExecutionsView = true;

        private BuildConfigurationBuilder(File rootProjectDirectory) {
            this.rootProjectDirectory = rootProjectDirectory;
        }

        public BuildConfigurationBuilder overrideWorkspaceConfiguration(boolean overrideWorkspaceConfiguration) {
            this.overrideWorkspaceConfiguration = overrideWorkspaceConfiguration;
            return this;
        }

        public BuildConfigurationBuilder gradleDistribution(GradleDistribution gradleDistribution) {
            this.gradleDistribution = gradleDistribution;
            return this;
        }

        public BuildConfigurationBuilder gradleUserHome(File gradleUserHome) {
            this.gradleUserHome = gradleUserHome;
            return this;
        }

        public BuildConfigurationBuilder javaHome(File javaHome) {
            this.javaHome = javaHome;
            return this;
        }

        public BuildConfigurationBuilder buildScansEnabled(boolean buildScansEnabled) {
            this.buildScansEnabled = buildScansEnabled;
            return this;
        }

        public BuildConfigurationBuilder offlineMode(boolean offlineMode) {
            this.offlineMode = offlineMode;
            return this;
        }

        public BuildConfigurationBuilder autoSync(boolean autoSync) {
            this.autoSync = autoSync;
            return this;
        }

        public BuildConfigurationBuilder arguments(List<String> arguments) {
            this.arguments = arguments;
            return this;
        }

        public BuildConfigurationBuilder jvmArguments(List<String> jvmArguments) {
            this.jvmArguments = jvmArguments;
            return this;
        }

        public BuildConfigurationBuilder showConsoleView(boolean showConsoleView) {
            this.showConsoleView = showConsoleView;
            return this;
        }

        public BuildConfigurationBuilder showExecutionsView(boolean showExecutionsView) {
            this.showExecutionsView = showExecutionsView;
            return this;
        }

        public BuildConfiguration build() {
            return new BuildConfiguration(this);
        }
    }
}

