/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.logging;

import java.util.Map;
import org.eclipse.buildship.core.internal.Logger;
import org.eclipse.buildship.core.internal.TraceScope;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class EclipseLogger
implements Logger {
    private final ILog log;
    private final String pluginId;
    private final Map<TraceScope, Boolean> tracingEnablement;

    public EclipseLogger(ILog log, String pluginId, Map<TraceScope, Boolean> tracingEnablement) {
        this.log = log;
        this.pluginId = pluginId;
        this.tracingEnablement = tracingEnablement;
    }

    @Override
    public boolean isScopeEnabled(TraceScope scope) {
        return this.tracingEnablement.get(scope);
    }

    @Override
    public void trace(TraceScope scope, String message) {
        if (this.tracingEnablement.get(scope).booleanValue()) {
            this.log.log((IStatus)new Status(1, this.pluginId, "[" + scope.getScopeKey() + "] " + message));
        }
    }

    @Override
    public void trace(TraceScope scope, String message, Throwable t) {
        if (this.tracingEnablement.get(scope).booleanValue()) {
            this.log.log((IStatus)new Status(1, this.pluginId, message, t));
        }
    }

    @Override
    public void info(String message) {
        this.log.log((IStatus)new Status(1, this.pluginId, message));
    }

    @Override
    public void info(String message, Throwable t) {
        this.log.log((IStatus)new Status(1, this.pluginId, message, t));
    }

    @Override
    public void warn(String message) {
        this.log.log((IStatus)new Status(2, this.pluginId, message));
    }

    @Override
    public void warn(String message, Throwable t) {
        this.log.log((IStatus)new Status(2, this.pluginId, message, t));
    }

    @Override
    public void error(String message) {
        this.log.log((IStatus)new Status(4, this.pluginId, message));
    }

    @Override
    public void error(String message, Throwable t) {
        this.log.log((IStatus)new Status(4, this.pluginId, message, t));
    }
}

