/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.cdt.cmake.core.CMakeErrorParser;
import org.eclipse.cdt.cmake.core.CMakeExecutionMarkerFactory;
import org.eclipse.cdt.cmake.core.ICMakeExecutionMarkerFactory;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.cdt.cmake.core.ICMakeToolChainManager;
import org.eclipse.cdt.cmake.core.ParsingConsoleOutputStream;
import org.eclipse.cdt.cmake.core.internal.Activator;
import org.eclipse.cdt.cmake.core.internal.CMakeConsoleWrapper;
import org.eclipse.cdt.cmake.core.internal.CMakePropertiesController;
import org.eclipse.cdt.cmake.core.internal.CMakeUtils;
import org.eclipse.cdt.cmake.core.internal.CommandDescriptorBuilder;
import org.eclipse.cdt.cmake.core.internal.IOsOverridesSelector;
import org.eclipse.cdt.cmake.core.internal.Messages;
import org.eclipse.cdt.cmake.core.properties.CMakeGenerator;
import org.eclipse.cdt.cmake.core.properties.ICMakeProperties;
import org.eclipse.cdt.cmake.core.properties.ICMakePropertiesController;
import org.eclipse.cdt.cmake.core.properties.IOsOverrides;
import org.eclipse.cdt.core.CommandLauncherManager;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.jsoncdb.core.CompileCommandsJsonParser;
import org.eclipse.cdt.jsoncdb.core.ISourceFileInfoConsumer;
import org.eclipse.cdt.jsoncdb.core.ParseRequest;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.service.prefs.Preferences;

public class CMakeBuildConfiguration
extends CBuildConfiguration {
    public static final String CMAKE_USE_UI_OVERRIDES = "cmake.use.ui.overrides";
    public static final boolean CMAKE_USE_UI_OVERRIDES_DEFAULT = false;
    public static final String CMAKE_GENERATOR = "cmake.generator";
    public static final String CMAKE_ARGUMENTS = "cmake.arguments";
    public static final String CMAKE_ENV = "cmake.environment";
    public static final String BUILD_COMMAND = "cmake.command.build";
    public static final String BUILD_COMMAND_DEFAULT = "cmake";
    public static final String CLEAN_COMMAND = "cmake.command.clean";
    public static final String CLEAN_COMMAND_DEFAULT = "clean";
    private ICMakeToolChainFile toolChainFile;
    private CMakePropertiesController pc;
    private Map<IResource, IScannerInfo> infoPerResource;
    private boolean cmakeListsModified;
    private boolean deleteCMakeCache;

    public CMakeBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        super(config, name);
        ICMakeToolChainManager manager = Activator.getService(ICMakeToolChainManager.class);
        this.toolChainFile = manager.getToolChainFileFor(this.getToolChain());
    }

    public CMakeBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain) {
        this(config, name, toolChain, null, "run");
    }

    public CMakeBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, ICMakeToolChainFile toolChainFile, String launchMode) {
        super(config, name, toolChain, launchMode);
        this.toolChainFile = toolChainFile;
    }

    public ICMakeToolChainFile getToolChainFile() {
        return this.toolChainFile;
    }

    private boolean isLocal() throws CoreException {
        IToolChain toolchain = this.getToolChain();
        return (Platform.getOS().equals(toolchain.getProperty("os")) || "linux-container".equals(toolchain.getProperty("os"))) && Platform.getOSArch().equals(toolchain.getProperty("arch"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
        try {
            ConsoleOutputStream infoStream = console.getInfoStream();
            java.nio.file.Path buildDir = this.getBuildDirectory();
            boolean runCMake = this.cmakeListsModified;
            if (this.deleteCMakeCache) {
                Files.deleteIfExists(buildDir.resolve("CMakeCache.txt"));
                this.deleteCMakeCache = false;
                runCMake = true;
            }
            ICMakeProperties cmakeProperties = this.getPropertiesController().load();
            boolean bl = !Files.exists(buildDir.resolve("CMakeCache.txt"), new LinkOption[0]);
            SimpleOsOverridesSelector overridesSelector = new SimpleOsOverridesSelector();
            if (!(runCMake |= bl)) {
                CMakeGenerator generator = overridesSelector.getOsOverrides(cmakeProperties).getGenerator();
                runCMake |= !Files.exists(buildDir.resolve(generator.getMakefileName()), new LinkOption[0]);
            }
            CommandDescriptorBuilder cmdBuilder = new CommandDescriptorBuilder(cmakeProperties, overridesSelector);
            if (runCMake) {
                CMakeBuildConfiguration.deleteCMakeErrorMarkers(project);
                infoStream.write(String.format(Messages.CMakeBuildConfiguration_Configuring, buildDir));
                CommandDescriptorBuilder.CommandDescriptor command = cmdBuilder.makeCMakeCommandline(this.toolChainFile != null ? this.toolChainFile.getPath() : null);
                IProject srcFolder = project;
                command.getArguments().add(new File(srcFolder.getLocationURI()).getAbsolutePath());
                infoStream.write(String.join((CharSequence)" ", command.getArguments()) + "\n");
                Path workingDir = new Path(this.getBuildDirectory().toString());
                Throwable throwable = null;
                Object var16_20 = null;
                try (CMakeErrorParser errorParser = new CMakeErrorParser(new CMakeExecutionMarkerFactory((IContainer)srcFolder));){
                    ParsingConsoleOutputStream errStream = new ParsingConsoleOutputStream(console.getErrorStream(), errorParser);
                    CMakeConsoleWrapper errConsole = new CMakeConsoleWrapper(console, errStream);
                    Process p = this.startBuildProcess(command.getArguments(), new IEnvironmentVariable[0], (IPath)workingDir, errConsole, monitor);
                    String arg0 = command.getArguments().get(0);
                    if (p == null) {
                        String msg = String.format(Messages.CMakeBuildConfiguration_Failure, "");
                        this.addMarker(new ProblemMarkerInfo((IResource)srcFolder.getProject(), -1, msg, 3, null, (IPath)new Path(arg0)));
                        return null;
                    }
                    int exitValue = this.watchProcess(errConsole, monitor);
                    if (exitValue != 0) {
                        String msg = String.format(Messages.CMakeBuildConfiguration_ExitFailure, arg0, exitValue);
                        this.addMarker((IResource)srcFolder.getProject(), -1, msg, 3, null);
                        return null;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                this.cmakeListsModified = false;
            }
            this.processCompileCommandsFile(console, monitor);
            infoStream.write(String.format(Messages.CMakeBuildConfiguration_BuildingIn, buildDir.toString()));
            Throwable throwable = null;
            Object var13_15 = null;
            try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
                epm.setOutputStream((OutputStream)console.getOutputStream());
                String envStr = this.getProperty(CMAKE_ENV);
                ArrayList<EnvironmentVariable> envVars = new ArrayList<EnvironmentVariable>();
                if (envStr != null) {
                    List<String> envList = CMakeUtils.stripEnvVars(envStr);
                    for (String s : envList) {
                        int index = s.indexOf("=");
                        if (index == -1) {
                            envVars.add(new EnvironmentVariable(s));
                            continue;
                        }
                        envVars.add(new EnvironmentVariable(s.substring(0, index), s.substring(index + 1)));
                    }
                }
                CommandDescriptorBuilder.CommandDescriptor commandDescr = cmdBuilder.makeCMakeBuildCommandline("all");
                List<String> command = commandDescr.getArguments();
                infoStream.write(String.join((CharSequence)" ", command) + "\n");
                Path workingDir = new Path(this.getBuildDirectory().toString());
                Process p = this.startBuildProcess(command, envVars.toArray(new IEnvironmentVariable[0]), (IPath)workingDir, console, monitor);
                if (p == null) {
                    console.getErrorStream().write(String.format(Messages.CMakeBuildConfiguration_Failure, ""));
                    return null;
                }
                int exitValue = this.watchProcess(new IConsoleParser[]{epm}, monitor);
                if (exitValue != 0) {
                    String msg2 = String.format(Messages.CMakeBuildConfiguration_ExitFailure, command.get(0), exitValue);
                    this.addMarker((IResource)project, -1, msg2, 3, null);
                }
                project.refreshLocal(2, monitor);
                infoStream.write(String.format(Messages.CMakeBuildConfiguration_BuildingComplete, epm.getErrorCount(), epm.getWarningCount(), buildDir.toString()));
                return new IProject[]{project};
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Activator.errorStatus(String.format(Messages.CMakeBuildConfiguration_Building, project.getName()), e));
        }
    }

    private String getCleanCommand() {
        String cleanCommand;
        String retVal = CLEAN_COMMAND_DEFAULT;
        Preferences settings = this.getSettings();
        boolean useUiOverrides = settings.getBoolean(CMAKE_USE_UI_OVERRIDES, false);
        if (useUiOverrides && !(cleanCommand = settings.get(CLEAN_COMMAND, CLEAN_COMMAND_DEFAULT)).isBlank()) {
            retVal = cleanCommand;
        }
        return retVal;
    }

    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ICMakeProperties cmakeProperties = this.getPropertiesController().load();
            CommandDescriptorBuilder cmdBuilder = new CommandDescriptorBuilder(cmakeProperties, new SimpleOsOverridesSelector());
            CommandDescriptorBuilder.CommandDescriptor command = cmdBuilder.makeCMakeBuildCommandline(this.getCleanCommand());
            ConsoleOutputStream outStream = console.getOutputStream();
            java.nio.file.Path buildDir = this.getBuildDirectory();
            if (!Files.exists(buildDir.resolve("CMakeFiles"), new LinkOption[0])) {
                outStream.write(Messages.CMakeBuildConfiguration_NotFound);
                return;
            }
            outStream.write(String.join((CharSequence)" ", command.getArguments()) + "\n");
            Path workingDir = new Path(this.getBuildDirectory().toString());
            Process p = this.startBuildProcess(command.getArguments(), new IEnvironmentVariable[0], (IPath)workingDir, console, monitor);
            if (p == null) {
                String msg = String.format(Messages.CMakeBuildConfiguration_Failure, "");
                this.addMarker(new ProblemMarkerInfo((IResource)project, -1, msg, 3, null, (IPath)new Path(command.getArguments().get(0))));
                return;
            }
            int exitValue = this.watchProcess(console, monitor);
            if (exitValue != 0) {
                String msg = String.format(Messages.CMakeBuildConfiguration_ExitFailure, command.getArguments().get(0), exitValue);
                this.addMarker((IResource)project, -1, msg, 3, null);
            }
            outStream.write(Messages.CMakeBuildConfiguration_BuildComplete);
            project.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException(Activator.errorStatus(String.format(Messages.CMakeBuildConfiguration_Cleaning, project.getName()), e));
        }
    }

    private void processCompileCommandsFile(IConsole console, IProgressMonitor monitor) throws CoreException {
        IFile file = this.getBuildContainer().getFile((IPath)new Path("compile_commands.json"));
        CompileCommandsJsonParser parser = new CompileCommandsJsonParser(new ParseRequest(file, (ISourceFileInfoConsumer)new CMakeIndexerInfoConsumer(this::setScannerInformation), CommandLauncherManager.getInstance().getCommandLauncher((ICBuildConfiguration)this), console));
        parser.parse(monitor);
    }

    private static void cleanDirectory(java.nio.file.Path dir) throws IOException {
        java.nio.file.Path[] files;
        SimpleFileVisitor<java.nio.file.Path> deltor = new SimpleFileVisitor<java.nio.file.Path>(){

            @Override
            public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException exc) throws IOException {
                super.postVisitDirectory(dir, exc);
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        };
        java.nio.file.Path[] pathArray = files = (java.nio.file.Path[])Files.list(dir).toArray(java.nio.file.Path[]::new);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            java.nio.file.Path file = pathArray[n2];
            Files.walkFileTree(file, (FileVisitor<? super java.nio.file.Path>)deltor);
            ++n2;
        }
    }

    private CMakePropertiesController getPropertiesController() {
        if (this.pc == null) {
            java.nio.file.Path filePath = java.nio.file.Path.of(this.getProject().getFile(".settings/CDT-cmake.yaml").getLocationURI());
            this.pc = new CMakePropertiesController(filePath, () -> {
                this.deleteCMakeCache = true;
            });
        }
        return this.pc;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ICMakePropertiesController.class.equals(adapter)) {
            return (T)this.pc;
        }
        return (T)super.getAdapter(adapter);
    }

    public IScannerInfo getScannerInformation(IResource resource) {
        if (this.infoPerResource == null) {
            try {
                this.processCompileCommandsFile(null, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        return this.infoPerResource == null ? null : this.infoPerResource.get(resource);
    }

    private void setScannerInformation(Map<IResource, IScannerInfo> infoPerResource) {
        this.infoPerResource = infoPerResource;
    }

    public void elementChanged(ElementChangedEvent event) {
        super.elementChanged(event);
        if (event.getType() != 1) {
            return;
        }
        if (!this.cmakeListsModified) {
            this.processElementDelta(event.getDelta());
        }
    }

    private boolean processElementDelta(ICElementDelta delta) {
        int n;
        IResourceDelta[] resourceDeltas;
        if (delta == null) {
            return true;
        }
        if (delta.getKind() == 4 && (delta.getFlags() & 1) != 0 && (resourceDeltas = delta.getResourceDeltas()) != null) {
            IResourceDelta[] iResourceDeltaArray = resourceDeltas;
            int n2 = resourceDeltas.length;
            n = 0;
            while (n < n2) {
                IResourceDelta resourceDelta = iResourceDeltaArray[n];
                IResource resource = resourceDelta.getResource();
                if (resource.getType() == 1) {
                    String name = resource.getName();
                    if (!resource.isDerived(512) && (name.equals("CMakeLists.txt") || name.endsWith(".cmake"))) {
                        this.cmakeListsModified = true;
                        return false;
                    }
                }
                ++n;
            }
        }
        ICElementDelta[] iCElementDeltaArray = delta.getAffectedChildren();
        n = iCElementDeltaArray.length;
        int n3 = 0;
        while (n3 < n) {
            ICElementDelta child = iCElementDeltaArray[n3];
            if (!this.processElementDelta(child)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean processLine(String line) {
        return true;
    }

    public boolean processLine(String line, List<Job> jobsArray) {
        return true;
    }

    public void shutdown() {
    }

    private static void deleteCMakeErrorMarkers(IProject project) throws CoreException {
        project.deleteMarkers(ICMakeExecutionMarkerFactory.CMAKE_PROBLEM_MARKER_ID, false, 2);
    }

    private static class CMakeIndexerInfoConsumer
    implements ISourceFileInfoConsumer {
        private Map<IResource, IScannerInfo> infoPerResource = new HashMap<IResource, IScannerInfo>();
        private boolean haveUpdates;
        private final Consumer<Map<IResource, IScannerInfo>> resultSetter;

        public CMakeIndexerInfoConsumer(Consumer<Map<IResource, IScannerInfo>> resultSetter) {
            this.resultSetter = Objects.requireNonNull(resultSetter);
        }

        public void acceptSourceFileInfo(String sourceFileName, List<String> systemIncludePaths, Map<String, String> definedSymbols, List<String> includePaths, List<String> macroFiles, List<String> includeFiles) {
            IFile file = this.getFileForCMakePath(sourceFileName);
            if (file != null) {
                ExtendedScannerInfo info = new ExtendedScannerInfo(definedSymbols, (String[])systemIncludePaths.stream().toArray(String[]::new), (String[])macroFiles.stream().toArray(String[]::new), (String[])includeFiles.stream().toArray(String[]::new), (String[])includePaths.stream().toArray(String[]::new));
                this.infoPerResource.put((IResource)file, (IScannerInfo)info);
                this.haveUpdates = true;
            }
        }

        private IFile getFileForCMakePath(String sourceFileName) {
            Path path = new Path(sourceFileName);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            return file;
        }

        public void shutdown() {
            if (this.haveUpdates) {
                this.resultSetter.accept(this.infoPerResource);
                this.infoPerResource = null;
                this.haveUpdates = false;
            }
        }
    }

    private class SimpleOsOverridesSelector
    implements IOsOverridesSelector {
        private SimpleOsOverridesSelector() {
        }

        @Override
        public IOsOverrides getOsOverrides(ICMakeProperties cmakeProperties) {
            String os = Platform.getOS();
            IOsOverrides overrides = "win32".equals(os) ? cmakeProperties.getWindowsOverrides() : cmakeProperties.getLinuxOverrides();
            return this.getUiOrOsOverrides(overrides);
        }

        private IOsOverrides getUiOrOsOverrides(IOsOverrides osOverrides) {
            IOsOverrides retVal = Objects.requireNonNull(osOverrides, "osOverrides must not be null");
            Preferences settings = CMakeBuildConfiguration.this.getSettings();
            boolean useUiOverrides = settings.getBoolean(CMakeBuildConfiguration.CMAKE_USE_UI_OVERRIDES, false);
            if (useUiOverrides) {
                String gen = settings.get(CMakeBuildConfiguration.CMAKE_GENERATOR, "");
                retVal.setGenerator(CMakeGenerator.getGenerator(gen));
                String extraArgsStr = settings.get(CMakeBuildConfiguration.CMAKE_ARGUMENTS, "");
                List<String> extraArgs = Arrays.stream(extraArgsStr.split("\\s+")).map(entry -> entry.trim()).collect(Collectors.toList());
                retVal.setExtraArguments(extraArgs);
                String buildCommand = settings.get(CMakeBuildConfiguration.BUILD_COMMAND, CMakeBuildConfiguration.BUILD_COMMAND_DEFAULT);
                if (!buildCommand.isBlank() && !CMakeBuildConfiguration.BUILD_COMMAND_DEFAULT.equals(buildCommand)) {
                    retVal.setUseDefaultCommand(false);
                    retVal.setCommand(buildCommand);
                }
            }
            return retVal;
        }
    }
}

