/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.properties;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CMakeGenerator {
    UnixMakefiles("Unix Makefiles"),
    Ninja("Ninja", "-k 0"){

        @Override
        public String getMakefileName() {
            return "build.ninja";
        }
    }
    ,
    NMakeMakefilesJOM("NMake Makefiles JOM"),
    MinGWMakefiles("MinGW Makefiles"),
    MSYSMakefiles("MSYS Makefiles"),
    NMakeMakefiles("NMake Makefiles"),
    BorlandMakefiles("Borland Makefiles"),
    WatcomWMake("Watcom WMake");

    private final String name;
    private String ignoreErrOption;

    private CMakeGenerator(String name, String ignoreErrOption) {
        this.name = name;
        this.ignoreErrOption = ignoreErrOption;
    }

    private CMakeGenerator(String name) {
        this(name, "-k");
    }

    public String getCMakeName() {
        return this.name;
    }

    public String getMakefileName() {
        return "Makefile";
    }

    public String getIgnoreErrOption() {
        return this.ignoreErrOption;
    }

    public static CMakeGenerator getGenerator(String generatorName) {
        CMakeGenerator[] cMakeGeneratorArray = CMakeGenerator.values();
        int n = cMakeGeneratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMakeGenerator gen = cMakeGeneratorArray[n2];
            if (gen.getCMakeName().equals(generatorName)) {
                return gen;
            }
            ++n2;
        }
        return null;
    }
}

