/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.codan.core.model.ICheckerInvocationContext;
import org.eclipse.cdt.codan.core.model.ICodanDisposable;
import org.eclipse.core.resources.IResource;

public class CheckerInvocationContext
implements ICheckerInvocationContext {
    private final IResource resource;
    private final Map<Class<?>, Object> objectStorage;

    public CheckerInvocationContext(IResource resource) {
        this.resource = resource;
        this.objectStorage = new HashMap();
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    @Override
    public synchronized <T> T get(Class<T> objectClass) {
        Object object = this.objectStorage.get(objectClass);
        if (object != null) {
            return (T)object;
        }
        for (Map.Entry<Class<?>, Object> entry : this.objectStorage.entrySet()) {
            if (!objectClass.isAssignableFrom(entry.getKey())) continue;
            return (T)entry.getValue();
        }
        return null;
    }

    @Override
    public synchronized <T extends ICodanDisposable> void add(T object) {
        Object old = this.objectStorage.put(object.getClass(), object);
        if (old != null && object != old) {
            this.objectStorage.put(old.getClass(), old);
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void dispose() {
        for (Map.Entry<Class<?>, Object> entry : this.objectStorage.entrySet()) {
            Object obj = entry.getValue();
            if (!(obj instanceof ICodanDisposable)) continue;
            ((ICodanDisposable)obj).dispose();
        }
        this.objectStorage.clear();
    }
}

