/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher.ui.preferences;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.docker.launcher.Messages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;

public class DockerHeaderPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private Table hdrTable;
    private TableViewer hdrTableViewer;
    private HeaderContentProvider provider;
    private Button removeButton;
    private List<IPath> directories;

    public DockerHeaderPreferencePage() {
        this.noDefaultAndApplyButton();
        this.provider = new HeaderContentProvider();
    }

    public void init(IWorkbench workbench) {
        this.directories = new ArrayList<IPath>();
        IPath pluginPath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.cdt.docker.launcher")).append("HEADERS");
        File d = pluginPath.toFile();
        if (d.exists() && d.isDirectory()) {
            File[] connections;
            File[] fileArray = connections = d.listFiles();
            int n = connections.length;
            int n2 = 0;
            while (n2 < n) {
                File connection = fileArray[n2];
                if (connection.isDirectory()) {
                    File[] images;
                    File[] fileArray2 = images = connection.listFiles();
                    int n3 = images.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File image = fileArray2[n4];
                        if (image.isDirectory()) {
                            this.directories.add(pluginPath.append(connection.getName()).append(image.getName()));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    protected Control createContents(Composite parent) {
        Composite page = DockerHeaderPreferencePage.createComposite(parent, 1, 2, false, null, -1, -1, 4);
        GridData gd = (GridData)page.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.hdrTable = new Table(page, 68354);
        this.hdrTable.setLinesVisible(true);
        this.hdrTable.setHeaderVisible(true);
        this.hdrTable.addListener(13, (Listener)this);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
        this.hdrTable.setLayout((Layout)tableLayout);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.hdrTable.setLayoutData((Object)gd);
        TableColumn connectionColumn = new TableColumn(this.hdrTable, 0);
        connectionColumn.setText(Messages.HeaderPreferencePage_Connection_Label);
        TableColumn imageColumn = new TableColumn(this.hdrTable, 0);
        imageColumn.setText(Messages.HeaderPreferencePage_Image_Label);
        this.hdrTableViewer = new TableViewer(this.hdrTable);
        this.hdrTableViewer.setContentProvider((IContentProvider)this.provider);
        this.hdrTableViewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.hdrTableViewer.setInput(this.directories);
        Composite buttonBar = DockerHeaderPreferencePage.createComposite(page, 1, 1, false, null, -1, -1, 4);
        gd = (GridData)buttonBar.getLayoutData();
        gd.grabExcessHorizontalSpace = false;
        gd.grabExcessVerticalSpace = true;
        this.removeButton = DockerHeaderPreferencePage.createPushButton(buttonBar, this, Messages.HeaderPreferencePage_Remove_Label, Messages.HeaderPreferencePage_Remove_Tooltip);
        this.removeButton.setEnabled(false);
        return parent;
    }

    private static Composite createComposite(Composite parent, int parentSpan, int numColumns, boolean border, String label, int marginSize, int spacingSize, int verticalAlignment) {
        boolean borderNeeded = border;
        if (label != null) {
            borderNeeded = true;
        }
        int style = 0;
        if (borderNeeded) {
            style |= 0x10;
        }
        Group composite = null;
        if (borderNeeded) {
            composite = new Group(parent, style);
            if (label != null) {
                composite.setText(label);
            }
        } else {
            composite = new Composite(parent, style);
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        if (marginSize != -1) {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        if (spacingSize != -1) {
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
        }
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalSpan = parentSpan;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = verticalAlignment;
        data.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public static Button createPushButton(Composite group, Listener listener, String label, String tooltip) {
        Button button = new Button(group, 8);
        button.setText(label);
        if (listener != null) {
            button.addListener(13, listener);
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
        if (tooltip != null) {
            button.setToolTipText(tooltip);
        }
        return button;
    }

    public void handleEvent(Event event) {
        if (event.type == 13) {
            if (event.widget == this.removeButton) {
                DialogStatus confirmed = new DialogStatus(false);
                Display.getDefault().syncExec(() -> {
                    boolean status = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.HeaderPreferencePage_Confirm_Removal_Title, (String)Messages.HeaderPreferencePage_Confirm_Removal_Msg);
                    confirmed.setStatus(status);
                });
                if (!confirmed.getStatus()) {
                    return;
                }
                int[] indicies = this.hdrTable.getSelectionIndices();
                int idx = indicies.length - 1;
                while (idx >= 0) {
                    IPath dirPath = this.directories.get(idx);
                    File f = dirPath.toFile();
                    if (f.exists() && f.isDirectory()) {
                        this.recursiveDelete(f);
                    }
                    this.directories.remove(idx);
                    --idx;
                }
                this.hdrTableViewer.refresh();
            }
            if (this.hdrTable.getSelectionCount() > 0) {
                this.removeButton.setEnabled(true);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
    }

    private void recursiveDelete(File dir) {
        File[] contents = dir.listFiles();
        if (contents != null) {
            File[] fileArray = contents;
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.recursiveDelete(f);
                ++n2;
            }
        }
        dir.delete();
    }

    private class DialogStatus {
        private boolean status;

        public DialogStatus(boolean status) {
            this.status = status;
        }

        public void setStatus(boolean status) {
            this.status = status;
        }

        public boolean getStatus() {
            return this.status;
        }
    }

    private final class HeaderContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private HeaderContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return DockerHeaderPreferencePage.this.directories.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String readNameFile(IPath path) {
            IPath namePath = path.append(".name");
            String name = path.lastSegment();
            if (!namePath.toFile().exists()) return name;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    FileReader reader = new FileReader(namePath.toFile());
                    try {
                        try (BufferedReader bufferReader = new BufferedReader(reader);){
                            name = bufferReader.readLine();
                        }
                        if (reader == null) return name;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (reader == null) throw throwable;
                        reader.close();
                        throw throwable;
                    }
                    reader.close();
                    return name;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return name;
        }

        public String getColumnText(Object element, int columnIndex) {
            IPath path = (IPath)element;
            if (columnIndex == 0) {
                IPath connectionPath = path.removeLastSegments(1);
                String connectionName = this.readNameFile(connectionPath);
                return connectionName;
            }
            String imageName = this.readNameFile(path);
            return imageName;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

