/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.launcher;

import org.eclipse.cdt.testsrunner.internal.TestsRunnerPlugin;
import org.eclipse.cdt.testsrunner.launcher.ITestsRunnerProvider;
import org.eclipse.cdt.testsrunner.launcher.ITestsRunnerProviderInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class TestsRunnerProviderInfo
implements ITestsRunnerProviderInfo {
    private static final String TESTS_RUNNER_FEATURES_ELEMENT = "features";
    private static final String TESTS_RUNNER_FEATURE_MULTIPLE_TEST_FILTER_ATTRIBUTE = "multipleTestFilter";
    private static final String TESTS_RUNNER_FEATURE_TESTING_TIME_MEASUREMENT_ATTRIBUTE = "testingTimeMeasurement";
    private static final String TESTS_RUNNER_FEATURE_DATA_STREAM_ATTRIBUTE = "dataStream";
    private static final String TESTS_RUNNER_ID_ATTRIBUTE = "id";
    private static final String TESTS_RUNNER_NAME_ATTRIBUTE = "name";
    private static final String TESTS_RUNNER_CLASS_ATTRIBUTE = "class";
    private static final String TESTS_RUNNER_DESCRIPTION_ATTRIBUTE = "description";
    private static final String TESTS_RUNNER_ERROR_STREAM_VALUE = "error";
    private IConfigurationElement element;

    public TestsRunnerProviderInfo(IConfigurationElement element) {
        this.element = element;
    }

    @Override
    public String getName() {
        return this.element.getAttribute(TESTS_RUNNER_NAME_ATTRIBUTE);
    }

    @Override
    public String getId() {
        return this.element.getAttribute(TESTS_RUNNER_ID_ATTRIBUTE);
    }

    @Override
    public String getDescription() {
        String result = this.element.getAttribute(TESTS_RUNNER_DESCRIPTION_ATTRIBUTE);
        return result == null ? "" : result;
    }

    public ITestsRunnerProvider instantiateTestsRunnerProvider() {
        try {
            Object object = this.element.createExecutableExtension(TESTS_RUNNER_CLASS_ATTRIBUTE);
            if (object instanceof ITestsRunnerProvider) {
                return (ITestsRunnerProvider)object;
            }
        }
        catch (CoreException e) {
            TestsRunnerPlugin.log(e);
        }
        return null;
    }

    private IConfigurationElement getFeatures() {
        IConfigurationElement[] featuresElements = this.element.getChildren(TESTS_RUNNER_FEATURES_ELEMENT);
        if (featuresElements.length == 1) {
            return featuresElements[0];
        }
        return null;
    }

    private String getFeatureAttributeValue(String featureName) {
        IConfigurationElement features = this.getFeatures();
        if (features != null) {
            return features.getAttribute(featureName);
        }
        return null;
    }

    private boolean getBooleanFeatureValue(String featureName, boolean defaultValue) {
        String attrValue = this.getFeatureAttributeValue(featureName);
        if (attrValue != null) {
            return Boolean.parseBoolean(attrValue);
        }
        return defaultValue;
    }

    @Override
    public boolean isAllowedMultipleTestFilter() {
        return this.getBooleanFeatureValue(TESTS_RUNNER_FEATURE_MULTIPLE_TEST_FILTER_ATTRIBUTE, false);
    }

    public boolean isAllowedTestingTimeMeasurement() {
        return this.getBooleanFeatureValue(TESTS_RUNNER_FEATURE_TESTING_TIME_MEASUREMENT_ATTRIBUTE, false);
    }

    @Override
    public boolean isOutputStreamRequired() {
        return !this.isErrorStreamRequired();
    }

    @Override
    public boolean isErrorStreamRequired() {
        String attrValue = this.getFeatureAttributeValue(TESTS_RUNNER_FEATURE_DATA_STREAM_ATTRIBUTE);
        if (attrValue != null) {
            return attrValue.equals(TESTS_RUNNER_ERROR_STREAM_VALUE);
        }
        return false;
    }
}

