/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.internal.ui.util.StringMatcher;
import org.eclipse.cdt.internal.ui.util.TwoArrayQuickSort;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SelectionList
extends Composite {
    private Object[] fElements;
    protected ILabelProvider fRenderer;
    private boolean fIgnoreCase;
    private String[] fRenderedStrings;
    private int[] fFilteredElements;
    private String fRememberedMatchText;
    private Table fList;
    private Text fText;

    public void addSelectionListener(SelectionListener listener) {
        this.fList.addSelectionListener(listener);
    }

    private void createList(int style) {
        this.fList = new Table((Composite)this, style);
        this.fList.setLayoutData((Object)new GridData(1808));
        this.fList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SelectionList.this.fRenderer.dispose();
            }
        });
    }

    private void createText() {
        this.fText = new Text((Composite)this, 2048);
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = false;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 1;
        this.fText.setLayoutData((Object)spec);
        Listener l = new Listener(){

            public void handleEvent(Event evt) {
                SelectionList.this.filter(false);
            }
        };
        this.fText.addListener(24, l);
    }

    public void filter(boolean forceUpdate) {
        int k = 0;
        String text = this.fText.getText();
        if (!forceUpdate && text.equals(this.fRememberedMatchText)) {
            return;
        }
        this.fRememberedMatchText = text;
        StringMatcher matcher = new StringMatcher(text + "*", this.fIgnoreCase, false);
        int i = 0;
        while (i < this.fElements.length) {
            if (matcher.match(this.fRenderedStrings[i])) {
                this.fFilteredElements[k] = i;
                ++k;
            }
            ++i;
        }
        this.fFilteredElements[k] = -1;
        this.updateListWidget(this.fFilteredElements, k);
    }

    public String getFilter() {
        return this.fText.getText();
    }

    public int[] getSelectionIndices() {
        return this.fList.getSelectionIndices();
    }

    public List<?> getSelection() {
        if (this.fList == null || this.fList.isDisposed() || this.fList.getSelectionCount() == 0) {
            return Collections.emptyList();
        }
        int[] listSelection = this.fList.getSelectionIndices();
        ArrayList<Object> selected = new ArrayList<Object>(listSelection.length);
        int i = 0;
        while (i < listSelection.length) {
            selected.add(this.fElements[this.fFilteredElements[listSelection[i]]]);
            ++i;
        }
        return selected;
    }

    public boolean isEmptyList() {
        return this.fElements == null || this.fElements.length == 0;
    }

    public SelectionList(Composite parent, int style, ILabelProvider renderer, boolean ignoreCase) {
        super(parent, 0);
        this.fRenderer = renderer;
        this.fIgnoreCase = ignoreCase;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.createText();
        this.createList(style);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.fList.removeSelectionListener(listener);
    }

    private String[] renderStrings() {
        String[] strings = new String[this.fElements.length];
        int i = 0;
        while (i < strings.length) {
            strings[i] = this.fRenderer.getText(this.fElements[i]);
            ++i;
        }
        TwoArrayQuickSort.sort(strings, this.fElements, this.fIgnoreCase);
        return strings;
    }

    public void selectFilterText() {
        this.fText.selectAll();
    }

    public void setElements(List<?> elements, boolean refilter) {
        this.fElements = elements == null ? new Object[0] : elements.toArray();
        this.fFilteredElements = new int[this.fElements.length + 1];
        this.fRenderedStrings = this.renderStrings();
        if (refilter) {
            this.filter(true);
        }
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.fText.setEnabled(enable);
        this.fList.setEnabled(enable);
    }

    public void setFilter(String pattern, boolean refilter) {
        this.fText.setText(pattern);
        if (refilter) {
            this.filter(true);
        }
    }

    public boolean setFocus() {
        return this.fText.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fText.setFont(font);
        this.fList.setFont(font);
    }

    protected void setSelection(int[] selection) {
        this.fList.setSelection(selection);
    }

    private void updateListWidget(int[] indices, int size) {
        if (this.fList == null || this.fList.isDisposed()) {
            return;
        }
        this.fList.setRedraw(false);
        int itemCount = this.fList.getItemCount();
        if (size < itemCount) {
            this.fList.remove(0, itemCount - size - 1);
        }
        TableItem[] items = this.fList.getItems();
        int i = 0;
        while (i < size) {
            TableItem ti = null;
            ti = i < itemCount ? items[i] : new TableItem(this.fList, i);
            ti.setText(this.fRenderedStrings[indices[i]]);
            Image img = this.fRenderer.getImage(this.fElements[indices[i]]);
            if (img != null) {
                ti.setImage(img);
            }
            ++i;
        }
        if (this.fList.getItemCount() > 0) {
            this.fList.setSelection(0);
        }
        this.fList.setRedraw(true);
        Event event = new Event();
        this.fList.notifyListeners(13, event);
    }
}

