/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.ui.language.ContentTypeMappingDialog;
import org.eclipse.cdt.internal.ui.language.ProjectLanguageMappingWidget;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ProjectContentTypeMappingDialog
extends ContentTypeMappingDialog {
    private Combo fConfiguration;
    private ICConfigurationDescription[] fConfigurations;
    private String[] fContentTypesIDs;
    private Set<String> fFilteredContentTypes;

    public ProjectContentTypeMappingDialog(Shell parentShell, ICConfigurationDescription[] configurations) {
        super(parentShell);
        this.fConfigurations = configurations;
        this.fContentTypesIDs = LanguageManager.getInstance().getRegisteredContentTypeIds();
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        int i = 0;
        while (i < this.fContentTypesIDs.length) {
            String name = contentTypeManager.getContentType(this.fContentTypesIDs[i]).getName();
            this.fContentTypeNamesToIDsMap.put(name, this.fContentTypesIDs[i]);
            ++i;
        }
    }

    private void configureConfigurations(Combo combo) {
        combo.add(PreferencesMessages.ContentTypeMappingsDialog_allConfigurations);
        int i = 0;
        while (i < this.fConfigurations.length) {
            combo.add(this.fConfigurations[i].getName());
            ++i;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout(2, false));
        Label configurationLabel = new Label(area, 131072);
        configurationLabel.setText(PreferencesMessages.ContentTypeMappingsDialog_configuration);
        this.fConfiguration = new Combo(area, 12);
        this.fConfiguration.setLayoutData((Object)new GridData(4, 4, true, true));
        this.configureConfigurations(this.fConfiguration);
        this.fConfiguration.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int index = ProjectContentTypeMappingDialog.this.fConfiguration.getSelectionIndex();
                if (index <= 0) {
                    ProjectContentTypeMappingDialog.this.fSelectedConfigurationName = null;
                    ProjectContentTypeMappingDialog.this.fSelectedConfigurationID = null;
                    ProjectContentTypeMappingDialog.this.configureContentTypes(ProjectContentTypeMappingDialog.this.fContentType, null);
                    ProjectContentTypeMappingDialog.this.getButton(0).setEnabled(false);
                    return;
                }
                int configurationIndex = index - 1;
                ICConfigurationDescription configuration = ProjectContentTypeMappingDialog.this.fConfigurations[configurationIndex];
                ProjectContentTypeMappingDialog.this.fSelectedConfigurationName = configuration.getName();
                ProjectContentTypeMappingDialog.this.fSelectedConfigurationID = configuration.getId();
                ProjectContentTypeMappingDialog.this.configureContentTypes(ProjectContentTypeMappingDialog.this.fContentType, configuration);
                ProjectContentTypeMappingDialog.this.getButton(0).setEnabled(ProjectContentTypeMappingDialog.this.isValidSelection());
            }
        });
        this.fConfiguration.select(0);
        Label contentTypeLabel = new Label(area, 131072);
        contentTypeLabel.setText(PreferencesMessages.ContentTypeMappingsDialog_contentType);
        this.fContentType = new Combo(area, 12);
        this.fContentType.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fContentType.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ProjectContentTypeMappingDialog.this.fSelectedContentTypeName = ProjectContentTypeMappingDialog.this.fContentType.getText();
                ProjectContentTypeMappingDialog.this.fSelectedContentTypeID = (String)ProjectContentTypeMappingDialog.this.fContentTypeNamesToIDsMap.get(ProjectContentTypeMappingDialog.this.fSelectedContentTypeName);
                ProjectContentTypeMappingDialog.this.getButton(0).setEnabled(ProjectContentTypeMappingDialog.this.isValidSelection());
            }
        });
        this.configureContentTypes(this.fContentType, null);
        Label languageLabel = new Label(area, 131072);
        languageLabel.setText(PreferencesMessages.ContentTypeMappingsDialog_language);
        this.fLanguage = new Combo(area, 12);
        this.fLanguage.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fLanguage.setItems(this.getLanguages());
        this.fLanguage.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ProjectContentTypeMappingDialog.this.fSelectedLanguageName = ProjectContentTypeMappingDialog.this.fLanguage.getText();
                ProjectContentTypeMappingDialog.this.fSelectedLanguageID = (String)ProjectContentTypeMappingDialog.this.fLanguageNamesToIDsMap.get(ProjectContentTypeMappingDialog.this.fSelectedLanguageName);
                ProjectContentTypeMappingDialog.this.getButton(0).setEnabled(ProjectContentTypeMappingDialog.this.isValidSelection());
            }
        });
        return area;
    }

    private void configureContentTypes(Combo combo, ICConfigurationDescription configuration) {
        combo.removeAll();
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        LinkedList<String> names = new LinkedList<String>();
        int i = 0;
        while (i < this.fContentTypesIDs.length) {
            String contentTypeId = this.fContentTypesIDs[i];
            String name = contentTypeManager.getContentType(contentTypeId).getName();
            if (configuration != null) {
                String key = ProjectLanguageMappingWidget.createFilterKey(configuration.getId(), contentTypeId);
                if (!this.fFilteredContentTypes.contains(key)) {
                    names.add(name);
                }
            } else {
                names.add(name);
            }
            ++i;
        }
        Collections.sort(names);
        for (String name : names) {
            combo.add(name);
        }
    }

    @Override
    protected boolean isValidSelection() {
        return this.fContentType.getSelectionIndex() != -1 && this.fLanguage.getSelectionIndex() != -1 && this.fConfiguration.getSelectionIndex() != -1;
    }

    public void setContentTypeFilter(Set<String> contentTypeFilter) {
        this.fFilteredContentTypes = contentTypeFilter;
    }

    public String getConfigurationID() {
        return this.fSelectedConfigurationID;
    }
}

