/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.unittest.ui;

import java.net.URI;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.unittest.CDTUnitTestPlugin;
import org.eclipse.cdt.unittest.ui.ActionsMessages;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.unittest.model.ITestRunSession;

public class OpenEditorAtLineAction
extends Action {
    private Shell shell;
    private String fileName;
    private int line;
    private ITestRunSession fTestRunSession;

    public OpenEditorAtLineAction(Shell shell, String fileName, ITestRunSession testRunSession, int line) {
        super(ActionsMessages.OpenInEditorAction_text);
        this.shell = shell;
        this.fileName = fileName;
        this.fTestRunSession = testRunSession;
        this.line = line;
        this.setToolTipText(ActionsMessages.OpenInEditorAction_tooltip);
    }

    public void run() {
        ILaunch launch;
        ILaunch iLaunch = launch = this.fTestRunSession != null ? this.fTestRunSession.getLaunch() : null;
        if (launch == null) {
            return;
        }
        this.lookupSource(this.fileName, this.line, launch);
    }

    private void lookupSource(String file, int lineNumber, ILaunch launch) {
        ILaunchConfiguration config;
        AbstractSourceLookupDirector director;
        ISourceLookupParticipant[] participants;
        ISourceLocator locator = launch.getSourceLocator();
        if (locator instanceof AbstractSourceLookupDirector && (participants = (director = (AbstractSourceLookupDirector)locator).getParticipants()).length == 0 && (config = launch.getLaunchConfiguration()) != null) {
            try {
                IPersistableSourceLocator sourceLocator;
                String id = config.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
                if (id == null) {
                    sourceLocator = CDebugUIPlugin.createDefaultSourceLocator();
                    sourceLocator.initializeDefaults(config);
                } else {
                    sourceLocator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(id);
                    String memento = config.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                    if (memento == null) {
                        sourceLocator.initializeDefaults(config);
                    } else {
                        sourceLocator.initializeFromMemento(memento);
                    }
                }
                locator = sourceLocator;
                launch.setSourceLocator((ISourceLocator)sourceLocator);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        ISourceLookupResult result = DebugUITools.lookupSource((Object)file, (ISourceLocator)locator);
        try {
            this.openEditorAndSelect(result, lineNumber);
        }
        catch (BadLocationException | PartInitException e) {
            CDTUnitTestPlugin.log(e);
        }
    }

    private void openEditorAndSelect(ISourceLookupResult result, int lineNumber) throws PartInitException, BadLocationException {
        IWorkbenchPage activePage;
        IEditorPart editor;
        Object sourceElement;
        IEditorInput input = result.getEditorInput();
        String editorID = result.getEditorId();
        if ((input == null || editorID == null) && (sourceElement = result.getSourceElement()) != null) {
            if (sourceElement instanceof LocalFileStorage) {
                IPath filePath = ((LocalFileStorage)sourceElement).getFullPath();
                URI fileURI = URIUtil.toURI((IPath)filePath);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile[] files = root.findFilesForLocationURI(fileURI);
                if (files.length > 0) {
                    sourceElement = files[0];
                }
            }
            IDebugModelPresentation pres = DebugUITools.newDebugModelPresentation((String)CDebugCorePlugin.getUniqueIdentifier());
            input = pres.getEditorInput(sourceElement);
            editorID = pres.getEditorId(input, sourceElement);
            pres.dispose();
        }
        if (input != null && editorID != null && (editor = IDE.openEditor((IWorkbenchPage)(activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()), (IEditorInput)input, (String)editorID)) instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            if (lineNumber > 0) {
                IDocumentProvider provider = textEditor.getDocumentProvider();
                IDocument document = provider.getDocument((Object)textEditor.getEditorInput());
                IRegion lineRegion = document.getLineInformation(lineNumber - 1);
                textEditor.selectAndReveal(lineRegion.getOffset(), lineRegion.getLength());
            }
        }
    }
}

