/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui.util;

import java.net.URL;
import org.eclipse.cdt.visualizer.core.ResourceManager;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class UIResourceManager
extends ResourceManager {
    protected AbstractUIPlugin m_UIplugin = null;
    protected UIResourceManager m_parentUIManager = null;
    protected ImageRegistry m_images = null;
    protected FontRegistry m_fonts = null;
    protected ColorRegistry m_colors = null;

    public UIResourceManager(AbstractUIPlugin plugin) {
        super((Plugin)plugin);
        this.m_UIplugin = plugin;
        this.getImageRegistry();
        this.getFontRegistry();
        this.getColorRegistry();
    }

    public void dispose() {
        this.disposeImageRegistry();
        this.disposeFontRegistry();
        this.disposeColorRegistry();
    }

    public void setParentManager(ResourceManager parentManager) {
        super.setParentManager(parentManager);
        this.m_parentUIManager = parentManager instanceof UIResourceManager ? (UIResourceManager)parentManager : null;
    }

    public UIResourceManager getParentManager() {
        return this.m_parentUIManager;
    }

    protected ImageRegistry getImageRegistry() {
        if (this.m_images == null) {
            this.m_images = this.m_UIplugin.getImageRegistry();
        }
        return this.m_images;
    }

    protected void disposeImageRegistry() {
        if (this.m_images != null) {
            this.m_images = null;
        }
    }

    public ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor result = null;
        if (path == null) {
            return result;
        }
        ImageRegistry images = this.getImageRegistry();
        result = images.getDescriptor(path);
        if (result == null) {
            URL url = this.m_UIplugin.getBundle().getEntry(path);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                images.put(path, desc);
                result = images.getDescriptor(path);
            } else {
                UIResourceManager parent = this.getParentManager();
                if (parent != null) {
                    result = parent.getImageDescriptor(path);
                }
            }
        }
        return result;
    }

    public Image getImage(String path) {
        Image result = null;
        if (path == null) {
            return result;
        }
        ImageRegistry images = this.getImageRegistry();
        result = images.get(path);
        if (result == null) {
            URL url = this.m_UIplugin.getBundle().getEntry(path);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                images.put(path, desc);
                result = images.get(path);
            } else {
                UIResourceManager parent = this.getParentManager();
                if (parent != null) {
                    result = parent.getImage(path);
                }
            }
        }
        return result;
    }

    protected FontRegistry getFontRegistry() {
        if (this.m_fonts == null) {
            Display display = UIResourceManager.getDisplay();
            this.m_fonts = new FontRegistry(display);
        }
        return this.m_fonts;
    }

    protected void disposeFontRegistry() {
        if (this.m_fonts != null) {
            this.m_fonts = null;
        }
    }

    public void setFont(String fontID, String fontName, int height, int style) {
        this.setCachedFont(fontID, fontName, height, style);
    }

    public Font getFont(String fontID) {
        return this.getCachedFont(fontID);
    }

    public Font getFont(String fontName, int height) {
        return this.getCachedFont(fontName, height, 0);
    }

    public Font getFont(String fontName, int height, int style) {
        return this.getCachedFont(fontName, height, style);
    }

    protected void setCachedFont(String fontID, String fontName, int height, int style) {
        FontData[] fontData = new FontData[]{new FontData(fontName, height, style)};
        FontRegistry fonts = this.getFontRegistry();
        fonts.put(fontID, fontData);
    }

    protected Font getCachedFont(String fontID) {
        Font result = null;
        FontRegistry fonts = this.getFontRegistry();
        if (fonts.hasValueFor(fontID)) {
            result = fonts.get(fontID);
        } else {
            UIResourceManager parent = this.getParentManager();
            if (parent != null) {
                result = parent.getCachedFont(fontID);
            }
        }
        return result;
    }

    protected Font getCachedFont(String fontName, int height, int style) {
        Font result = null;
        String fontID = fontName + "," + height + "," + style;
        result = this.getCachedFont(fontID);
        if (result == null) {
            this.setCachedFont(fontID, fontName, height, style);
            result = this.getCachedFont(fontID);
        }
        return result;
    }

    protected ColorRegistry getColorRegistry() {
        if (this.m_colors == null) {
            Display display = UIResourceManager.getDisplay();
            this.m_colors = new ColorRegistry(display);
        }
        return this.m_colors;
    }

    protected void disposeColorRegistry() {
        if (this.m_colors != null) {
            this.m_colors = null;
        }
    }

    public Color getColor(int colorID) {
        return UIResourceManager.getDisplay().getSystemColor(colorID);
    }

    public Color getColor(String colorID) {
        return this.getCachedColor(colorID);
    }

    public Color getColor(int red, int green, int blue) {
        return this.getCachedColor(red, green, blue);
    }

    protected void setCachedColor(String colorID, int red, int green, int blue) {
        RGB rgb = new RGB(red, green, blue);
        ColorRegistry colors = this.getColorRegistry();
        colors.put(colorID, rgb);
    }

    protected Color getCachedColor(String colorID) {
        Color result = null;
        ColorRegistry colors = this.getColorRegistry();
        if (colors.hasValueFor(colorID)) {
            result = colors.get(colorID);
        } else {
            UIResourceManager parent = this.getParentManager();
            if (parent != null) {
                result = parent.getCachedColor(colorID);
            }
        }
        return result;
    }

    protected Color getCachedColor(int red, int green, int blue) {
        Color result = null;
        String colorID = "Color[R=" + red + ",G=" + green + ",B=" + blue + "]";
        result = this.getCachedColor(colorID);
        if (result == null) {
            this.setCachedColor(colorID, red, green, blue);
            result = this.getCachedColor(colorID);
        }
        return result;
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

