/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.localstore.RefreshLocalVisitor;
import org.eclipse.core.internal.localstore.UnifiedTreeNode;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class RefreshLocalAliasVisitor
extends RefreshLocalVisitor {
    public RefreshLocalAliasVisitor(IProgressMonitor monitor) {
        super(monitor);
    }

    @Override
    protected void createResource(UnifiedTreeNode node, Resource target) throws CoreException {
        super.createResource(node, target);
        IFileStore store = node.getStore();
        if (store == null) {
            return;
        }
        IResource[] aliases = this.workspace.getAliasManager().computeAliases(target, store);
        if (aliases != null) {
            IResource[] iResourceArray = aliases;
            int n = aliases.length;
            int n2 = 0;
            while (n2 < n) {
                IResource alias = iResourceArray[n2];
                if (alias.getProject().isOpen() && !((Resource)alias).isFiltered()) {
                    super.createResource(node, (Resource)alias);
                }
                ++n2;
            }
        }
    }

    @Override
    protected void deleteResource(UnifiedTreeNode node, Resource target) throws CoreException {
        super.deleteResource(node, target);
        IFileStore store = node.getStore();
        if (store == null) {
            return;
        }
        IResource[] aliases = this.workspace.getAliasManager().computeAliases(target, store);
        if (aliases != null) {
            boolean wasFilteredOut = false;
            if (store.fetchInfo() != null && store.fetchInfo().exists()) {
                wasFilteredOut = target.isFiltered();
            }
            IResource[] iResourceArray = aliases;
            int n = aliases.length;
            int n2 = 0;
            while (n2 < n) {
                IResource aliase = iResourceArray[n2];
                if (aliase.getProject().isOpen()) {
                    if (wasFilteredOut) {
                        if (((Resource)aliase).isFiltered()) {
                            super.deleteResource(node, (Resource)aliase);
                        }
                    } else {
                        super.deleteResource(node, (Resource)aliase);
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    protected void resourceChanged(UnifiedTreeNode node, Resource target) {
        super.resourceChanged(node, target);
        IFileStore store = node.getStore();
        if (store == null) {
            return;
        }
        IResource[] aliases = this.workspace.getAliasManager().computeAliases(target, store);
        if (aliases != null) {
            IResource[] iResourceArray = aliases;
            int n = aliases.length;
            int n2 = 0;
            while (n2 < n) {
                IResource aliase = iResourceArray[n2];
                if (aliase.getProject().isOpen()) {
                    super.resourceChanged(node, (Resource)aliase);
                }
                ++n2;
            }
        }
    }

    @Override
    protected void fileToFolder(UnifiedTreeNode node, Resource target) throws CoreException {
        super.fileToFolder(node, target);
        IFileStore store = node.getStore();
        if (store == null) {
            return;
        }
        IResource[] aliases = this.workspace.getAliasManager().computeAliases(target, store);
        if (aliases != null) {
            IResource[] iResourceArray = aliases;
            int n = aliases.length;
            int n2 = 0;
            while (n2 < n) {
                IResource aliase = iResourceArray[n2];
                super.fileToFolder(node, (Resource)aliase);
                ++n2;
            }
        }
    }

    @Override
    protected void folderToFile(UnifiedTreeNode node, Resource target) throws CoreException {
        super.folderToFile(node, target);
        IFileStore store = node.getStore();
        if (store == null) {
            return;
        }
        IResource[] aliases = this.workspace.getAliasManager().computeAliases(target, store);
        if (aliases != null) {
            IResource[] iResourceArray = aliases;
            int n = aliases.length;
            int n2 = 0;
            while (n2 < n) {
                IResource aliase = iResourceArray[n2];
                super.folderToFile(node, (Resource)aliase);
                ++n2;
            }
        }
    }

    @Override
    protected void refresh(Container parent) throws CoreException {
        parent.getLocalManager().refresh(parent, 0, true, null);
    }
}

