/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.apache.internal.derby.connection;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.drivers.jdbc.JDBCConnection;

public class DerbyEmbeddedJDBCConnection
extends JDBCConnection {
    private static Map sDerbyConnections = new HashMap();
    private static Map sConnectionReferenceCount = new HashMap();

    public DerbyEmbeddedJDBCConnection(IConnectionProfile profile, Class factoryClass) {
        super(profile, factoryClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Connection connection = (Connection)this.getRawConnection();
        if (connection == null) {
            return;
        }
        Map map = sDerbyConnections;
        synchronized (map) {
            int count = (Integer)sConnectionReferenceCount.get(connection);
            if (count == 1) {
                String baseDBURL = this.getBaseDBURL();
                try {
                    String driverClass = this.getDriverDefinition().getProperty("org.eclipse.datatools.connectivity.db.driverClass");
                    Driver driver = (Driver)connection.getClass().getClassLoader().loadClass(driverClass).newInstance();
                    driver.connect(String.valueOf(baseDBURL) + ";shutdown=true", new Properties());
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (SQLException sQLException) {
                    sConnectionReferenceCount.remove(connection);
                    sDerbyConnections.remove(baseDBURL);
                }
                catch (Exception exception) {}
            } else {
                sConnectionReferenceCount.put(connection, --count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createConnection(ClassLoader cl) throws Throwable {
        Connection connection;
        Map map = sDerbyConnections;
        synchronized (map) {
            String dbName = this.getBaseDBURL();
            if (sDerbyConnections.containsKey(dbName)) {
                connection = (Connection)sDerbyConnections.get(dbName);
                int count = (Integer)sConnectionReferenceCount.get(connection);
                sConnectionReferenceCount.put(connection, ++count);
            } else {
                connection = (Connection)super.createConnection(cl);
                sDerbyConnections.put(dbName, connection);
                sConnectionReferenceCount.put(connection, 1);
            }
        }
        return connection;
    }

    private String getBaseDBURL() {
        String connectURL = this.getConnectionProfile().getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.URL");
        int propertyStart = connectURL.indexOf(59);
        String baseURL = propertyStart < 0 ? connectURL : connectURL.substring(0, propertyStart);
        return baseURL;
    }
}

