/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class PropertiesLabelProvider
implements ITableLabelProvider {
    private IPropertySet mPropSet;

    public PropertiesLabelProvider(IPropertySet pset) {
        this.mPropSet = pset;
    }

    public void setPropertySet(IPropertySet pset) {
        this.mPropSet = pset;
    }

    public IPropertySet getPropertySet() {
        return this.mPropSet;
    }

    public String getColumnText(Object object, int columnIndex) {
        String val = "";
        if (object instanceof IConfigurationElement) {
            IConfigurationElement prop = (IConfigurationElement)object;
            String name = prop.getAttribute("name");
            String id = prop.getAttribute("id");
            String value = prop.getAttribute("value");
            String visible = prop.getAttribute("visible");
            boolean propvisible = true;
            if (visible != null && visible.equals("false")) {
                propvisible = false;
            }
            if (propvisible) {
                switch (columnIndex) {
                    case 0: {
                        val = name;
                        break;
                    }
                    case 1: {
                        String propval;
                        val = value;
                        if (this.mPropSet == null || (propval = this.mPropSet.getBaseProperties().getProperty(id)) == null || propval.length() <= 0) break;
                        val = propval;
                    }
                }
            }
        }
        return val == null ? "" : val;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

