/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.wizards.DriverUIContributorRegistry;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributor;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class DriverUIContributorComposite {
    private Group group = null;
    private StackLayout stackLayout = null;
    private DialogPage wizardPage;
    private IDriverUIContributor uiContributor = null;
    private IDriverUIContributorInformation contributorInformation;
    private boolean isReadOnly = false;

    public DriverUIContributorComposite(Composite parent, DialogPage wizardPage, IDriverUIContributorInformation contributorInformation, boolean isReadOnly) {
        this.createControls(parent);
        this.wizardPage = wizardPage;
        this.contributorInformation = contributorInformation;
        this.isReadOnly = isReadOnly;
    }

    public void createControls(Composite parent) {
        Composite baseComposite = new Composite(parent, 0);
        baseComposite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.heightHint = 350;
        gridData.widthHint = 400;
        baseComposite.setLayoutData((Object)gridData);
        this.group = new Group(baseComposite, 0);
        this.group.setText(ConnectivityUIPlugin.getDefault().getResourceString("DriverUIContributorComposite.group"));
        this.group.setLayoutData((Object)new GridData(1808));
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 3;
        this.stackLayout.marginWidth = 3;
        this.group.setLayout((Layout)this.stackLayout);
    }

    public void setDriverTemplateID(String driverTemplateID) {
        this.uiContributor = DriverUIContributorRegistry.getInstance().getDriverUIContributor(driverTemplateID);
        Composite contributedComposite = this.uiContributor.getContributedDriverUI((Composite)this.group, this.isReadOnly);
        contributedComposite.setParent((Composite)this.group);
        this.uiContributor.setDialogPage(this.wizardPage);
        this.uiContributor.setDriverUIContributorInformation(this.contributorInformation);
        this.uiContributor.determineContributorCompletion();
        this.stackLayout.topControl = contributedComposite;
        this.group.layout();
        this.uiContributor.loadProperties();
    }

    public boolean determineContributorCompletion() {
        boolean isComplete = false;
        if (this.uiContributor != null) {
            isComplete = this.uiContributor.determineContributorCompletion();
        }
        return isComplete;
    }

    public List getSummaryData() {
        List summaryData = new ArrayList();
        summaryData = this.uiContributor.getSummaryData();
        return summaryData;
    }
}

