/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.datatools.enablement.ibm.util.StringCache;

public class SliceKey {
    public static final SliceKey EMPTY = new SliceKey(new String[0]);
    String[] keyvalues;
    String keystring;

    public SliceKey(String ... values) {
        if (values == null) {
            this.keyvalues = new String[0];
        } else {
            this.keyvalues = new String[values.length];
            int ii = 0;
            while (ii < values.length) {
                if (values[ii] == null) {
                    values[ii] = "";
                }
                this.keyvalues[ii] = StringCache.getUniqueString(values[ii].trim());
                ++ii;
            }
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = this.keyvalues;
        int n = this.keyvalues.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s == null) {
                sb.setLength(0);
                break;
            }
            SliceKey.addKeyValue(sb, s);
            ++n2;
        }
        this.keystring = StringCache.getUniqueString(sb.toString());
    }

    public int hashCode() {
        if (this.keyvalues == null) {
            return 0;
        }
        int hash = 0;
        int ii = 0;
        while (ii < this.keyvalues.length) {
            hash <<= 1;
            String kv = this.keyvalues[ii];
            if (kv != null) {
                hash ^= kv.hashCode();
            }
            ++ii;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SliceKey)) {
            return false;
        }
        SliceKey other = (SliceKey)o;
        if (this.keyvalues.length != other.keyvalues.length) {
            return false;
        }
        int ii = 0;
        while (ii < this.keyvalues.length) {
            String kv1 = this.keyvalues[ii];
            String kv2 = other.keyvalues[ii];
            if (kv1 == null ? kv2 != null : !kv1.equals(kv2)) {
                return false;
            }
            ++ii;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.keyvalues == null || this.keyvalues.length == 0;
    }

    public String toString() {
        return this.getKeyString();
    }

    public String getKeyString() {
        return this.keystring;
    }

    public static String[] extractFilterValues(String keystring) {
        if (keystring == null) {
            return new String[0];
        }
        StringTokenizer toker = new StringTokenizer(keystring, ".");
        ArrayList<String> filterValues = new ArrayList<String>();
        while (toker.hasMoreTokens()) {
            filterValues.add(SliceKey.decode(toker.nextToken()));
        }
        return filterValues.toArray(new String[filterValues.size()]);
    }

    private static String decode(String encoded) {
        int amp = encoded.indexOf(38);
        if (amp < 0) {
            return encoded;
        }
        StringBuilder sb = new StringBuilder(encoded);
        while (amp >= 0 && amp < sb.length() - 1) {
            sb.deleteCharAt(amp);
            if (sb.charAt(amp) == 'd') {
                sb.setCharAt(amp, '.');
            }
            amp = sb.indexOf("&", amp + 1);
        }
        return sb.toString();
    }

    private static void addKeyValue(StringBuilder sb, String value) {
        if (sb.length() > 0) {
            sb.append('.');
        }
        if (value.indexOf(46) >= 0 || value.indexOf(38) >= 0) {
            int ii = 0;
            while (ii < value.length()) {
                char c = value.charAt(ii);
                switch (c) {
                    case '.': {
                        sb.append("&d");
                        break;
                    }
                    case '&': {
                        sb.append("&&");
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                ++ii;
            }
        } else {
            sb.append(value);
        }
    }
}

