/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.accesscontrol.impl;

import java.util.Collection;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.SQLAccessControlPackage;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.impl.SQLObjectImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class PrivilegeImpl
extends SQLObjectImpl
implements Privilege {
    protected static final boolean GRANTABLE_EDEFAULT = false;
    protected boolean grantable = false;
    protected static final String ACTION_EDEFAULT = null;
    protected String action = ACTION_EDEFAULT;
    protected static final boolean WITH_HIERARCHY_EDEFAULT = false;
    protected boolean withHierarchy = false;
    protected AuthorizationIdentifier grantor;
    protected EList actionObjects;
    protected SQLObject object;

    protected PrivilegeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SQLAccessControlPackage.Literals.PRIVILEGE;
    }

    @Override
    public boolean isGrantable() {
        return this.grantable;
    }

    @Override
    public void setGrantable(boolean newGrantable) {
        boolean oldGrantable = this.grantable;
        this.grantable = newGrantable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldGrantable, this.grantable));
        }
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public void setAction(String newAction) {
        String oldAction = this.action;
        this.action = newAction;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldAction, (Object)this.action));
        }
    }

    @Override
    public boolean isWithHierarchy() {
        return this.withHierarchy;
    }

    @Override
    public void setWithHierarchy(boolean newWithHierarchy) {
        boolean oldWithHierarchy = this.withHierarchy;
        this.withHierarchy = newWithHierarchy;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldWithHierarchy, this.withHierarchy));
        }
    }

    @Override
    public AuthorizationIdentifier getGrantor() {
        if (this.grantor != null && this.grantor.eIsProxy()) {
            InternalEObject oldGrantor = (InternalEObject)this.grantor;
            this.grantor = (AuthorizationIdentifier)this.eResolveProxy(oldGrantor);
            if (this.grantor != oldGrantor && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 11, (Object)oldGrantor, (Object)this.grantor));
            }
        }
        return this.grantor;
    }

    public AuthorizationIdentifier basicGetGrantor() {
        return this.grantor;
    }

    public NotificationChain basicSetGrantor(AuthorizationIdentifier newGrantor, NotificationChain msgs) {
        AuthorizationIdentifier oldGrantor = this.grantor;
        this.grantor = newGrantor;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldGrantor, (Object)newGrantor);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setGrantor(AuthorizationIdentifier newGrantor) {
        if (newGrantor != this.grantor) {
            NotificationChain msgs = null;
            if (this.grantor != null) {
                msgs = ((InternalEObject)this.grantor).eInverseRemove((InternalEObject)this, 12, AuthorizationIdentifier.class, msgs);
            }
            if (newGrantor != null) {
                msgs = ((InternalEObject)newGrantor).eInverseAdd((InternalEObject)this, 12, AuthorizationIdentifier.class, msgs);
            }
            if ((msgs = this.basicSetGrantor(newGrantor, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)newGrantor, (Object)newGrantor));
        }
    }

    @Override
    public AuthorizationIdentifier getGrantee() {
        if (this.eContainerFeatureID != 12) {
            return null;
        }
        return (AuthorizationIdentifier)this.eContainer();
    }

    public NotificationChain basicSetGrantee(AuthorizationIdentifier newGrantee, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newGrantee, 12, msgs);
        return msgs;
    }

    @Override
    public void setGrantee(AuthorizationIdentifier newGrantee) {
        if (newGrantee != this.eInternalContainer() || this.eContainerFeatureID != 12 && newGrantee != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newGrantee)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newGrantee != null) {
                msgs = ((InternalEObject)newGrantee).eInverseAdd((InternalEObject)this, 13, AuthorizationIdentifier.class, msgs);
            }
            if ((msgs = this.basicSetGrantee(newGrantee, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)newGrantee, (Object)newGrantee));
        }
    }

    @Override
    public EList getActionObjects() {
        if (this.actionObjects == null) {
            this.actionObjects = new EObjectResolvingEList(SQLObject.class, (InternalEObject)this, 13);
        }
        return this.actionObjects;
    }

    @Override
    public SQLObject getObject() {
        if (this.object != null && this.object.eIsProxy()) {
            InternalEObject oldObject = (InternalEObject)this.object;
            this.object = (SQLObject)this.eResolveProxy(oldObject);
            if (this.object != oldObject && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 14, (Object)oldObject, (Object)this.object));
            }
        }
        return this.object;
    }

    public SQLObject basicGetObject() {
        return this.object;
    }

    public NotificationChain basicSetObject(SQLObject newObject, NotificationChain msgs) {
        SQLObject oldObject = this.object;
        this.object = newObject;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldObject, (Object)newObject);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setObject(SQLObject newObject) {
        if (newObject != this.object) {
            NotificationChain msgs = null;
            if (this.object != null) {
                msgs = ((InternalEObject)this.object).eInverseRemove((InternalEObject)this, 7, SQLObject.class, msgs);
            }
            if (newObject != null) {
                msgs = ((InternalEObject)newObject).eInverseAdd((InternalEObject)this, 7, SQLObject.class, msgs);
            }
            if ((msgs = this.basicSetObject(newObject, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)newObject, (Object)newObject));
        }
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 11: {
                if (this.grantor != null) {
                    msgs = ((InternalEObject)this.grantor).eInverseRemove((InternalEObject)this, 12, AuthorizationIdentifier.class, msgs);
                }
                return this.basicSetGrantor((AuthorizationIdentifier)otherEnd, msgs);
            }
            case 12: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetGrantee((AuthorizationIdentifier)otherEnd, msgs);
            }
            case 14: {
                if (this.object != null) {
                    msgs = ((InternalEObject)this.object).eInverseRemove((InternalEObject)this, 7, SQLObject.class, msgs);
                }
                return this.basicSetObject((SQLObject)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 11: {
                return this.basicSetGrantor(null, msgs);
            }
            case 12: {
                return this.basicSetGrantee(null, msgs);
            }
            case 14: {
                return this.basicSetObject(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID) {
            case 12: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 13, AuthorizationIdentifier.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.isGrantable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return this.getAction();
            }
            case 10: {
                return this.isWithHierarchy() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                if (resolve) {
                    return this.getGrantor();
                }
                return this.basicGetGrantor();
            }
            case 12: {
                return this.getGrantee();
            }
            case 13: {
                return this.getActionObjects();
            }
            case 14: {
                if (resolve) {
                    return this.getObject();
                }
                return this.basicGetObject();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setGrantable((Boolean)newValue);
                return;
            }
            case 9: {
                this.setAction((String)newValue);
                return;
            }
            case 10: {
                this.setWithHierarchy((Boolean)newValue);
                return;
            }
            case 11: {
                this.setGrantor((AuthorizationIdentifier)newValue);
                return;
            }
            case 12: {
                this.setGrantee((AuthorizationIdentifier)newValue);
                return;
            }
            case 13: {
                this.getActionObjects().clear();
                this.getActionObjects().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.setObject((SQLObject)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setGrantable(false);
                return;
            }
            case 9: {
                this.setAction(ACTION_EDEFAULT);
                return;
            }
            case 10: {
                this.setWithHierarchy(false);
                return;
            }
            case 11: {
                this.setGrantor(null);
                return;
            }
            case 12: {
                this.setGrantee(null);
                return;
            }
            case 13: {
                this.getActionObjects().clear();
                return;
            }
            case 14: {
                this.setObject(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.grantable;
            }
            case 9: {
                return ACTION_EDEFAULT == null ? this.action != null : !ACTION_EDEFAULT.equals(this.action);
            }
            case 10: {
                return this.withHierarchy;
            }
            case 11: {
                return this.grantor != null;
            }
            case 12: {
                return this.getGrantee() != null;
            }
            case 13: {
                return this.actionObjects != null && !this.actionObjects.isEmpty();
            }
            case 14: {
                return this.object != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (grantable: ");
        result.append(this.grantable);
        result.append(", action: ");
        result.append(this.action);
        result.append(", withHierarchy: ");
        result.append(this.withHierarchy);
        result.append(')');
        return result.toString();
    }
}

