/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerCorePlugin;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerMessages;
import org.eclipse.datatools.sqltools.debugger.model.SPThread;
import org.eclipse.datatools.sqltools.debugger.model.SPValue;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.osgi.util.NLS;

public class SPWatchExpressionDelegate
implements IWatchExpressionDelegate {
    protected static final String[] EMPTY_ERROR_MESSAGES = new String[0];

    public void evaluateExpression(final String expression, IDebugElement context, IWatchExpressionListener listener) {
        Object expressionResult;
        try {
            IThread[] threads;
            IThread thread = null;
            if (context instanceof IStackFrame) {
                thread = ((IStackFrame)context).getThread();
            } else if (context instanceof IThread) {
                thread = (IThread)context;
            } else if (context instanceof IDebugTarget && (threads = ((IDebugTarget)context).getThreads()) != null && threads.length > 0) {
                thread = threads[0];
            }
            if (!(thread instanceof SPThread)) {
                expressionResult = null;
            } else {
                SPThread spThread = (SPThread)thread;
                if (!spThread.supportEvaluateExpression()) {
                    Object expressionResult2 = null;
                    DebugException de = new DebugException((IStatus)new Status(2, DebuggerCorePlugin.PLUGIN_ID, 0, NLS.bind((String)DebuggerMessages.SPWatchExpressionDelegate_unsupported, (Object[])new Object[]{spThread.getDatabaseIdentifier().toString()}), (Throwable)new Exception(NLS.bind((String)DebuggerMessages.SPWatchExpressionDelegate_unsupported, (Object[])new Object[]{spThread.getDatabaseIdentifier().toString()}))));
                    throw de;
                }
                final SPValue value = spThread.evaluateExpression(expression);
                expressionResult = new IWatchExpressionResult(){

                    public IValue getValue() {
                        return value;
                    }

                    public boolean hasErrors() {
                        return false;
                    }

                    public String[] getErrorMessages() {
                        return EMPTY_ERROR_MESSAGES;
                    }

                    public String getExpressionText() {
                        return expression;
                    }

                    public DebugException getException() {
                        return null;
                    }
                };
            }
        }
        catch (Exception ex) {
            final DebugException debugex = ex instanceof DebugException ? (DebugException)((Object)ex) : (ex instanceof CoreException ? new DebugException(((CoreException)((Object)ex)).getStatus()) : new DebugException((IStatus)new Status(4, DebuggerCorePlugin.PLUGIN_ID, 0, DebuggerMessages.SPWatchExpressionDelegate_error, (Throwable)ex)));
            expressionResult = new IWatchExpressionResult(){

                public IValue getValue() {
                    return null;
                }

                public boolean hasErrors() {
                    return true;
                }

                public String[] getErrorMessages() {
                    return new String[]{debugex.getMessage()};
                }

                public String getExpressionText() {
                    return expression;
                }

                public DebugException getException() {
                    return debugex;
                }
            };
        }
        listener.watchEvaluationFinished(expressionResult);
    }
}

