/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.filters;

import org.eclipse.datatools.sqltools.result.internal.model.ResultInstance;
import org.eclipse.datatools.sqltools.result.internal.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ResultStatusFilter
extends ViewerFilter {
    IPreferenceStore _store;

    public ResultStatusFilter(IPreferenceStore store) {
        this._store = store;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof ResultInstance) {
            ResultInstance instance = (ResultInstance)element;
            if (!instance.isParentResult()) {
                return true;
            }
            switch (instance.getStatus()) {
                case 3: {
                    return this._store.getBoolean(PreferenceConstants.PROFILE_FILTERS_STATUS_SUCCESS);
                }
                case 6: {
                    return this._store.getBoolean(PreferenceConstants.PROFILE_FILTERS_STATUS_FAILED);
                }
                case 5: {
                    return this._store.getBoolean(PreferenceConstants.PROFILE_FILTERS_STATUS_TERMINATED);
                }
                case 4: {
                    return this._store.getBoolean(PreferenceConstants.PROFILE_FILTERS_STATUS_WARNING);
                }
                case 7: {
                    return this._store.getBoolean(PreferenceConstants.PROFILE_FILTERS_STATUS_CRITICAL);
                }
                case 2: {
                    return true;
                }
                case 1: {
                    return true;
                }
            }
        }
        return false;
    }
}

