/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.actions;

import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilder;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.views.execute.ParameterMarkers;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.BaseExecuteAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ExecuteAction
extends BaseExecuteAction {
    SQLBuilder _sqlBuilder;
    String _sSQL;

    public ExecuteAction() {
        this.setText(Messages._UI_MENU_EXECUTE);
    }

    public void setSQLBuilder(SQLBuilder sqlBuilder) {
        this._sqlBuilder = sqlBuilder;
    }

    public DatabaseIdentifier getDatabaseIdentifier() {
        if (this._sqlBuilder != null) {
            return this._sqlBuilder.getDomainModel().getDatabaseIdentifier();
        }
        return null;
    }

    public Runnable getPostRun() {
        Runnable postRun = new Runnable(){

            @Override
            public void run() {
                IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (activeEditor instanceof SQLBuilderEditor && ((SQLBuilderEditor)activeEditor).getSQLBuilder() == ExecuteAction.this._sqlBuilder) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)activeEditor);
                }
            }
        };
        return postRun;
    }

    public String getSQLStatements() {
        return this._sSQL;
    }

    private boolean substituteParameters(QueryStatement stmt) {
        ParameterMarkers pm = new ParameterMarkers(stmt);
        this._sSQL = pm.substituteParameters();
        return pm.getContinueExecution();
    }

    public void update() {
        this.setEnabled(this._sqlBuilder.getDomainModel().isConnected());
    }

    public void run() {
        this._sSQL = null;
        boolean currentTextModified = this._sqlBuilder.getSourceViewer().isTextChanged();
        this._sqlBuilder.getSourceViewer().setTextChanged(true);
        this._sqlBuilder.getSourceViewer().setParseRequired(true);
        this._sqlBuilder.reparseIfRequired();
        this._sqlBuilder.getSourceViewer().setTextChanged(currentTextModified);
        SQLDomainModel domainModel = this._sqlBuilder.getDomainModel();
        QueryStatement stmt = domainModel.getSQLStatement();
        boolean continueExecution = this.substituteParameters(stmt);
        if (continueExecution) {
            super.run();
            this._sqlBuilder.notifySQLExecuted();
        }
    }
}

