/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.actions;

import java.util.ArrayList;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewSQLStatementComposite
extends Composite
implements ModifyListener,
SelectionListener {
    public static final int STATEMENT_TYPE_SAMPLE = 6;
    public static final int STATEMENT_TYPE_NONE = 7;
    private static final int QUERY_BUILDER = 0;
    private static final int SQL_SOURCE_EDITOR = 1;
    private static final int INITIAL_TEXTFIELD_WIDTH = 250;
    protected Text fStatementNameText;
    protected Combo fStatementTypeCombo;
    protected Button fQueryBuilderButton;
    protected Button fSQLEditorButton;
    protected Label fErrorLabel;
    private String fStatementName;
    private int fStatementType = 0;
    private int fEditorType = 0;
    private int fPreviousSelectedIndex = 0;
    private boolean fSupportsExtendedStatementTypesForEditor = true;

    public NewSQLStatementComposite(Composite parent, int style) {
        super(parent, style);
        this.createStatementIDPart(this);
        this.createEditorPart(this);
        GridData idData = new GridData();
        idData.grabExcessHorizontalSpace = false;
        idData.horizontalAlignment = 4;
        idData.horizontalSpan = 2;
        this.fErrorLabel = new Label((Composite)this, 64);
        this.fErrorLabel.setLayoutData((Object)idData);
    }

    private void createStatementIDPart(Composite parent) {
        Group statementGroup = new Group(parent, 4);
        statementGroup.setText(Messages.datatools_sqlbuilder_newStatementPage_statementID);
        GridData idData = new GridData();
        idData.grabExcessHorizontalSpace = true;
        idData.horizontalAlignment = 4;
        statementGroup.setLayoutData((Object)idData);
        GridLayout idLayout = new GridLayout();
        idLayout.numColumns = 2;
        statementGroup.setLayout((Layout)idLayout);
        Label nameLabel = new Label((Composite)statementGroup, 16384);
        nameLabel.setText(Messages.datatools_sqlbuilder_newStatementPage_statementName);
        GridData nameData = new GridData();
        nameData.horizontalAlignment = 1;
        this.fStatementNameText = new Text((Composite)statementGroup, 2048);
        GridData nameTextData = new GridData();
        nameTextData.widthHint = 250;
        nameTextData.grabExcessHorizontalSpace = true;
        nameTextData.horizontalAlignment = 4;
        this.fStatementNameText.setLayoutData((Object)nameTextData);
        this.fStatementNameText.addModifyListener((ModifyListener)this);
        Label typeLabel = new Label((Composite)statementGroup, 16384);
        typeLabel.setText(Messages.datatools_sqlbuilder_newStatementPage_statementType);
        GridData typeData = new GridData();
        typeData.horizontalAlignment = 1;
        this.fStatementTypeCombo = new Combo((Composite)statementGroup, 12);
        this.fStatementTypeCombo.addSelectionListener((SelectionListener)this);
        this.fStatementTypeCombo.setItems(this.getStatementTypes());
        this.fStatementTypeCombo.select(0);
        GridData comboData = new GridData();
        comboData.horizontalAlignment = 4;
        this.fStatementTypeCombo.setLayoutData((Object)comboData);
    }

    private void createEditorPart(Composite parent) {
        Group editorGroup = new Group(parent, 4);
        editorGroup.setText(Messages.datatools_sqlbuilder_newStatementPage_editUsing);
        GridData editData = new GridData();
        editData.grabExcessHorizontalSpace = true;
        editData.horizontalAlignment = 4;
        editorGroup.setLayoutData((Object)editData);
        GridLayout editLayout = new GridLayout();
        editorGroup.setLayout((Layout)editLayout);
        this.fQueryBuilderButton = new Button((Composite)editorGroup, 16);
        this.fQueryBuilderButton.setSelection(true);
        this.fQueryBuilderButton.addSelectionListener((SelectionListener)this);
        this.fQueryBuilderButton.setText(Messages.datatools_sqlbuilder_newStatementPage_sqlQueryBuilder);
        GridData queryBuilderData = new GridData();
        queryBuilderData.horizontalAlignment = 1;
        queryBuilderData.grabExcessHorizontalSpace = true;
        this.fQueryBuilderButton.setLayoutData((Object)queryBuilderData);
        this.fSQLEditorButton = new Button((Composite)editorGroup, 16);
        this.fSQLEditorButton.addSelectionListener((SelectionListener)this);
        this.fSQLEditorButton.setText(Messages.datatools_sqlbuilder_newStatementPage_sqlEditor);
        GridData sqlEditorData = new GridData();
        sqlEditorData.horizontalAlignment = 1;
        sqlEditorData.grabExcessHorizontalSpace = true;
        this.fSQLEditorButton.setLayoutData((Object)sqlEditorData);
    }

    public String getEditorID() {
        String editorID = null;
        if (this.fEditorType == 0) {
            editorID = "org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderEditor";
        } else if (this.fEditorType == 1) {
            editorID = "org.eclipse.datatools.sqltools.sqleditor";
        }
        return editorID;
    }

    protected int getEditorType() {
        return this.fEditorType;
    }

    public String getStatementName() {
        return this.fStatementName;
    }

    public int getStatementType() {
        return this.fStatementType;
    }

    protected String[] getStatementTypes() {
        ArrayList<String> stmtTypeList = new ArrayList<String>();
        stmtTypeList.add("SELECT");
        stmtTypeList.add("INSERT");
        stmtTypeList.add("UPDATE");
        stmtTypeList.add("DELETE");
        stmtTypeList.add("FULLSELECT");
        stmtTypeList.add("WITH");
        if (this.getEditorType() == 1 && this.getSupportsExtendedStatementTypesForEditor()) {
            stmtTypeList.add(Messages.datatools_sqlbuilder_newStatementPage_sampleStatements);
            stmtTypeList.add(Messages.datatools_sqlbuilder_newStatementPage_none);
        }
        String[] stmtTypeArray = stmtTypeList.toArray(new String[stmtTypeList.size()]);
        return stmtTypeArray;
    }

    public Text getStatementNameText() {
        return this.fStatementNameText;
    }

    public Combo getStatementTypeCombo() {
        return this.fStatementTypeCombo;
    }

    public Button getQueryBuilderButton() {
        return this.fQueryBuilderButton;
    }

    public Button getSQLEditorButton() {
        return this.fSQLEditorButton;
    }

    public boolean getSupportsExtendedStatementTypesForEditor() {
        return this.fSupportsExtendedStatementTypesForEditor;
    }

    public void modifyText(ModifyEvent evt) {
        Object source = evt.getSource();
        if (source == this.getStatementNameText()) {
            String statementName = this.getStatementNameText().getText().trim();
            this.setStatementName(statementName);
        }
    }

    protected void setEditorType(int editorType) {
        this.fEditorType = editorType;
    }

    public void setStatementName(String statementName) {
        this.fStatementName = statementName;
    }

    public void setErrorLabelText(String text) {
        this.fErrorLabel.setText(text);
        this.update();
    }

    public void setStatementType(int statementType) {
        this.fStatementType = statementType;
    }

    public void setSupportsExtendedStatementTypesForEditor(boolean supported) {
        this.fSupportsExtendedStatementTypesForEditor = supported;
    }

    public void widgetSelected(SelectionEvent evt) {
        Object source = evt.getSource();
        if (source == this.getStatementTypeCombo()) {
            int statementType;
            this.fPreviousSelectedIndex = statementType = this.getStatementTypeCombo().getSelectionIndex();
            this.setStatementType(statementType);
        } else if (source == this.getQueryBuilderButton()) {
            this.setEditorType(0);
            String[] statementTypes = this.getStatementTypes();
            this.fStatementTypeCombo.setItems(statementTypes);
            if (this.fPreviousSelectedIndex < statementTypes.length) {
                this.fStatementTypeCombo.select(this.fPreviousSelectedIndex);
                this.setStatementType(this.fPreviousSelectedIndex);
            } else {
                this.fPreviousSelectedIndex = 0;
                this.fStatementTypeCombo.select(this.fPreviousSelectedIndex);
                this.setStatementType(this.fPreviousSelectedIndex);
            }
        } else if (source == this.getSQLEditorButton()) {
            this.setEditorType(1);
            String[] statementTypes = this.getStatementTypes();
            this.fStatementTypeCombo.setItems(statementTypes);
            this.fStatementTypeCombo.select(this.fPreviousSelectedIndex);
            this.setStatementType(this.fPreviousSelectedIndex);
        }
    }

    public void widgetDefaultSelected(SelectionEvent evt) {
    }
}

