/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.graph.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.helper.JoinHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;

public class CreateJoinCommand
extends Command {
    private ValueExpressionColumn srcColumn;
    private ValueExpressionColumn tgtColumn;
    private TableExpression sourceTable;
    private TableExpression targetTable;
    private QuerySelect selectStatement;

    public void setSelectStatement(QuerySelect statement) {
        this.selectStatement = statement;
    }

    public void setSourceColumn(ValueExpressionColumn column) {
        this.srcColumn = column;
    }

    public void setTargetColumn(ValueExpressionColumn column) {
        this.tgtColumn = column;
    }

    public void setSourceTable(TableExpression table) {
        this.sourceTable = table;
    }

    public void setTargetTable(TableExpression table) {
        this.targetTable = table;
    }

    public void undo() {
    }

    private List getFromClauseList(QuerySelect selectStmt) {
        EList fromList = new ArrayList();
        if (selectStmt != null) {
            fromList = selectStmt.getFromClause();
        }
        return fromList;
    }

    public boolean canExecute() {
        List fromContent;
        int status;
        if (this.tgtColumn == null && this.targetTable == null) {
            return true;
        }
        return this.srcColumn != null && this.tgtColumn != null && (status = JoinHelper.checkJoin((List)(fromContent = this.getFromClauseList(this.selectStatement)), (TableExpression)this.sourceTable, (TableExpression)this.targetTable, (ValueExpressionColumn)this.srcColumn, (ValueExpressionColumn)this.tgtColumn, (boolean)false)) == 0;
    }

    public void execute() {
        List fromContent = this.getFromClauseList(this.selectStatement);
        ValueExpressionColumn srcCol = ExpressionHelper.createValueExpressionColumn(this.srcColumn);
        ValueExpressionColumn tgtCol = ExpressionHelper.createValueExpressionColumn(this.tgtColumn);
        JoinHelper.checkJoin((List)fromContent, (TableExpression)this.sourceTable, (TableExpression)this.targetTable, (ValueExpressionColumn)srcCol, (ValueExpressionColumn)tgtCol, (boolean)false);
        int joinKind = 0;
        if (this.sourceTable != null && this.targetTable != null && srcCol != null && tgtCol != null) {
            JoinHelper.addJoin((List)fromContent, (TableExpression)this.sourceTable, (TableExpression)this.targetTable, (ValueExpressionColumn)srcCol, (ValueExpressionColumn)tgtCol, (int)joinKind);
            SelectHelper.refresh(this.selectStatement);
        }
    }
}

