/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.graph.commands;

import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.Predicate;
import org.eclipse.datatools.modelbase.sql.query.PredicateBasic;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableJoined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.helper.JoinHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SearchConditionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.ColumnEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.JoinEditPart;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;

public class MoveJoinCommand
extends Command {
    JoinEditPart joinEditPart;
    ColumnEditPart target;
    QuerySelect selectStatement;
    boolean changeSource;

    public MoveJoinCommand() {
        super("wire connection");
    }

    public void cancel() {
    }

    public boolean canExecute() {
        return this.updateJoin(false);
    }

    public void execute() {
        if (this.joinEditPart == null || this.target == null) {
            return;
        }
        this.updateJoin(true);
    }

    private boolean updateJoin(boolean changeJoin) {
        ValueExpressionColumn targetColumn;
        TableExpression targetTable;
        ValueExpressionColumn sourceColumn;
        TableExpression sourceTable;
        boolean isValid = false;
        TableExpression oldSourceTable = this.joinEditPart.getSourceTable();
        ValueExpressionColumn oldSourceColumn = this.joinEditPart.getSourceColumn();
        TableExpression oldTargetTable = this.joinEditPart.getTargetTable();
        ValueExpressionColumn oldTargetColumn = this.joinEditPart.getTargetColumn();
        TableExpression newTargetTable = (TableExpression)this.target.getTableEditPart().getModel();
        ValueExpressionColumn newColumn = (ValueExpressionColumn)this.target.getModel();
        if (this.isChangeSource()) {
            sourceTable = newTargetTable;
            sourceColumn = newColumn;
            targetTable = oldTargetTable;
            targetColumn = oldTargetColumn;
        } else {
            sourceTable = oldSourceTable;
            sourceColumn = oldSourceColumn;
            targetTable = newTargetTable;
            targetColumn = newColumn;
        }
        EList fromContent = this.selectStatement.getFromClause();
        int validJoin = JoinHelper.checkJoin((List)fromContent, (TableExpression)sourceTable, (TableExpression)targetTable, (ValueExpressionColumn)sourceColumn, (ValueExpressionColumn)targetColumn, (boolean)true);
        if (validJoin == 0) {
            isValid = true;
            if (changeJoin) {
                ValueExpressionColumn srcCol = ExpressionHelper.createValueExpressionColumn(sourceColumn);
                ValueExpressionColumn tgtCol = ExpressionHelper.createValueExpressionColumn(targetColumn);
                SQLQueryObject joinSource = this.joinEditPart.getSQLJoin();
                int joinType = 0;
                if (joinSource instanceof TableJoined) {
                    joinType = ((TableJoined)joinSource).getJoinOperator().getValue();
                    this.joinEditPart.removeJoin();
                    JoinHelper.addJoin((List)fromContent, (TableExpression)sourceTable, (TableExpression)targetTable, (ValueExpressionColumn)srcCol, (ValueExpressionColumn)tgtCol, (int)joinType);
                } else if (joinSource instanceof QuerySearchCondition) {
                    PredicateBasic newPred = SearchConditionHelper.buildPredicateBasic((QueryValueExpression)srcCol, (QueryValueExpression)tgtCol, this.joinEditPart.getSQLPredicate().getComparisonOperator().toString());
                    QuerySearchCondition newCondition = SearchConditionHelper.replacePredicate((QuerySearchCondition)joinSource, (Predicate)this.joinEditPart.getSQLPredicate(), (Predicate)newPred);
                    this.selectStatement.setWhereClause(newCondition);
                }
                SelectHelper.refresh(this.selectStatement);
            }
        }
        return isValid;
    }

    public String getDescription() {
        return "MoveJoin change";
    }

    public JoinEditPart getJoinPart() {
        return this.joinEditPart;
    }

    public void setJoinPart(JoinEditPart source) {
        this.joinEditPart = source;
    }

    public ColumnEditPart getColumnPart() {
        return this.target;
    }

    public void setColumnPart(ColumnEditPart target) {
        this.target = target;
    }

    public boolean isChangeSource() {
        return this.changeSource;
    }

    public void setChangeSource(boolean v) {
        this.changeSource = v;
    }

    public void setSelectStatement(QuerySelect statement) {
        this.selectStatement = statement;
    }

    public void redo() {
    }

    public void undo() {
    }
}

