/*******************************************************************************
 * Copyright (c) 2005, 2016 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 *******************************************************************************/
package org.eclipse.dltk.console;

public class ScriptConsolePrompt {
	private final String newCommand;

	private final String continueCommand;

	private boolean mode;

	public ScriptConsolePrompt(String newCommand, String appendCommand) {
		this.newCommand = newCommand;
		this.continueCommand = appendCommand;
		this.mode = true;
	}

	public void setMode(boolean mode) {
		this.mode = mode;
	}

	@Override
	public String toString() {
		return mode ? newCommand : continueCommand;
	}
}