/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.manipulation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.core.manipulation.ScriptManipulationPlugin;
import org.eclipse.dltk.internal.corext.refactoring.changes.UndoSourceModuleChange;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.UndoEdit;

public class SourceModuleChange
extends TextFileChange {
    private final ISourceModule fCUnit;
    private ChangeDescriptor fDescriptor;

    public SourceModuleChange(String name, ISourceModule cunit) {
        super(name, SourceModuleChange.getFile(cunit));
        Assert.isNotNull((Object)cunit);
        this.fCUnit = cunit;
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)cunit);
        if (toolkit != null) {
            this.setTextType(toolkit.getFileType());
        }
    }

    private static IFile getFile(ISourceModule cunit) {
        return (IFile)cunit.getResource();
    }

    public Object getModifiedElement() {
        return this.fCUnit;
    }

    public ISourceModule getSourceModule() {
        return this.fCUnit;
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        this.fCUnit.becomeWorkingCopy(null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        return super.acquireDocument((IProgressMonitor)new SubProgressMonitor(pm, 1));
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
        boolean isModified = this.isDocumentModified();
        super.releaseDocument(document, pm);
        try {
            this.fCUnit.discardWorkingCopy();
        }
        finally {
            if (isModified && !this.isDocumentAcquired()) {
                if (this.fCUnit.isWorkingCopy()) {
                    this.fCUnit.reconcile(false, null, null);
                } else {
                    this.fCUnit.makeConsistent(pm);
                }
            }
        }
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
        try {
            return new UndoSourceModuleChange(this.getName(), this.fCUnit, edit, stampToRestore, this.getSaveMode());
        }
        catch (CoreException e) {
            ScriptManipulationPlugin.log(e);
            return null;
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ISourceModule.class.equals(adapter)) {
            return (T)this.fCUnit;
        }
        return (T)super.getAdapter(adapter);
    }

    public void setDescriptor(ChangeDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    public ChangeDescriptor getDescriptor() {
        return this.fDescriptor;
    }
}

