/*******************************************************************************
 * Copyright (c) 2005, 2017 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 *******************************************************************************/
package org.eclipse.dltk.dbgp.internal.commands;

import org.eclipse.dltk.dbgp.DbgpBaseCommands;
import org.eclipse.dltk.dbgp.DbgpRequest;
import org.eclipse.dltk.dbgp.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.commands.IDbgpStreamCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlParser;

public class DbgpStreamCommands extends DbgpBaseCommands
		implements IDbgpStreamCommands {
	private static final String STDERR_COMMAND = "stderr"; //$NON-NLS-1$

	private static final String STDOUT_COMMAND = "stdout"; //$NON-NLS-1$

	protected boolean execCommand(String command, int value)
			throws DbgpException {
		DbgpRequest request = createRequest(command);
		request.addOption("-c", value); //$NON-NLS-1$
		return DbgpXmlParser.parseSuccess(communicate(request));
	}

	public DbgpStreamCommands(IDbgpCommunicator communicator) {
		super(communicator);
	}

	@Override
	public boolean configureStdout(int value) throws DbgpException {
		return execCommand(STDOUT_COMMAND, value);
	}

	@Override
	public boolean configureStderr(int value) throws DbgpException {
		return execCommand(STDERR_COMMAND, value);
	}
}
