/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.dbgp.IDbgpRawPacket;
import org.eclipse.dltk.dbgp.internal.utils.Base64Helper;
import org.eclipse.dltk.internal.debug.core.model.StrUtils;

public class DbgpRequest
implements IDbgpRawPacket {
    private final Map<String, Object> options;
    private final String command;
    private final boolean async;
    private String data;

    public DbgpRequest(String command) {
        this(command, false);
    }

    public DbgpRequest(String command, boolean async) {
        this.command = command;
        this.async = async;
        this.options = new HashMap<String, Object>();
    }

    public String getCommand() {
        return this.command;
    }

    public void addOption(String optionNmae, int optionValue) {
        this.addOption(optionNmae, (Object)optionValue);
    }

    public void addOption(String optionName, Object optionValue) {
        if (optionValue == null) {
            throw new IllegalArgumentException();
        }
        this.options.put(optionName, optionValue.toString());
    }

    public void removeOption(String optionName) {
        this.options.remove(optionName);
    }

    public String getOption(String optionName) {
        return (String)this.options.get(optionName);
    }

    public boolean hasOption(String optionName) {
        return this.options.containsKey(optionName);
    }

    public int optionCount() {
        return this.options.size();
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.command);
        for (Map.Entry<String, Object> entry : this.options.entrySet()) {
            sb.append(' ');
            sb.append(entry.getKey());
            sb.append(' ');
            sb.append(entry.getValue());
        }
        if (this.data != null) {
            sb.append(" -- ");
            sb.append(Base64Helper.encodeString(this.data));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof DbgpRequest) {
            DbgpRequest request = (DbgpRequest)o;
            return this.command.equals(request.command) && this.async == request.async && this.options.equals(request.options) && StrUtils.equals(this.data, request.data);
        }
        return false;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void writeTo(OutputStream output) throws IOException {
        output.write(this.toString().getBytes("ASCII"));
    }

    @Override
    public String getPacketAsString() {
        return this.toString();
    }
}

