/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.tcl.activestatedebugger.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InstrumentationFeature {
    AUTOLOAD("autoload", Messages.instrumentation_autoload_caption),
    DYNPROC("dynproc", Messages.instrumentation_dynproc_caption),
    ITCL("itcl", Messages.instrumentation_itcl_caption),
    TCLX("tclx", Messages.instrumentation_tclx_caption),
    EXPECT("expect", Messages.instrumentation_expect_caption);

    private final String value;
    private final String caption;

    private InstrumentationFeature(String value, String caption) {
        this.value = value;
        this.caption = caption;
    }

    public String getValue() {
        return this.value;
    }

    public String getCaption() {
        return this.caption;
    }

    public static Set<InstrumentationFeature> decode(String iFeatures) {
        if (iFeatures == null) {
            return Collections.emptySet();
        }
        HashSet<InstrumentationFeature> result = new HashSet<InstrumentationFeature>();
        String[] parts = iFeatures.split(",");
        int i = 0;
        while (i < parts.length) {
            try {
                result.add(InstrumentationFeature.valueOf(parts[i]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++i;
        }
        return result;
    }

    public static String encode(Set<InstrumentationFeature> features) {
        if (features == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (InstrumentationFeature feature : features) {
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(feature.name());
        }
        return sb.toString();
    }

    public static String encode(InstrumentationFeature ... features) {
        if (features == null) {
            return "";
        }
        HashSet<InstrumentationFeature> featureSet = new HashSet<InstrumentationFeature>();
        InstrumentationFeature[] instrumentationFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            InstrumentationFeature feature = instrumentationFeatureArray[n2];
            featureSet.add(feature);
            ++n2;
        }
        return InstrumentationFeature.encode(featureSet);
    }
}

