/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import org.eclipse.dltk.core.SimpleClassDLTKExtensionManager;
import org.eclipse.dltk.tcl.internal.ui.TclSemanticPositionUpdater;
import org.eclipse.dltk.tcl.internal.ui.text.CodeTemplateTclSourceViewerConfiguration;
import org.eclipse.dltk.tcl.internal.ui.text.TclPartitionScanner;
import org.eclipse.dltk.tcl.internal.ui.text.TclSourceViewerConfiguration;
import org.eclipse.dltk.tcl.ui.semantilhighlighting.ISemanticHighlightingExtension;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingUpdater;
import org.eclipse.dltk.ui.editor.highlighting.SemanticHighlighting;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.templates.TemplateVariableProcessor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.texteditor.ITextEditor;

public class TclTextTools
extends ScriptTextTools {
    private SimpleClassDLTKExtensionManager extensions = new SimpleClassDLTKExtensionManager("org.eclipse.dltk.tcl.ui.tclSemanticHighlighting");
    private static final String[] LEGAL_CONTENT_TYPES = new String[]{"__tcl_string", "__tcl_comment"};

    public TclTextTools(boolean autoDisposeOnDisplayDispose) {
        super("__tcl_partitioning", LEGAL_CONTENT_TYPES, autoDisposeOnDisplayDispose);
    }

    public ScriptSourceViewerConfiguration createSourceViewerConfiguraton(IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        return new TclSourceViewerConfiguration(this.getColorManager(), preferenceStore, editor, partitioning);
    }

    public ScriptSourceViewerConfiguration createSourceViewerConfiguraton(IPreferenceStore preferenceStore, ITextEditor editor, TemplateVariableProcessor variableProcessor) {
        return new CodeTemplateTclSourceViewerConfiguration(this.getColorManager(), preferenceStore, null, variableProcessor);
    }

    public IPartitionTokenScanner getPartitionScanner() {
        return new TclPartitionScanner();
    }

    private ISemanticHighlightingExtension[] getExtensions() {
        Object[] objects = this.extensions.getObjects();
        ISemanticHighlightingExtension[] exts = new ISemanticHighlightingExtension[objects.length];
        int i = 0;
        while (i < objects.length) {
            exts[i] = (ISemanticHighlightingExtension)objects[i];
            ++i;
        }
        return exts;
    }

    public SemanticHighlighting[] getSemanticHighlightings() {
        return this.getSemanticPositionUpdater("org.eclipse.dltk.tcl.core.nature").getSemanticHighlightings();
    }

    public ISemanticHighlightingUpdater getSemanticPositionUpdater(String natureId) {
        return new TclSemanticPositionUpdater(this.getExtensions());
    }

    public static final class SH
    extends SemanticHighlighting {
        private final String preferenceKey;
        private final String bgColor;
        private final String description;

        public SH(String editorXmlTagNameColor, String bgColor, String desc) {
            this.preferenceKey = editorXmlTagNameColor;
            this.bgColor = bgColor;
            this.description = desc;
        }

        public boolean isSemanticOnly() {
            return this.description != null;
        }

        public String getPreferenceKey() {
            return this.preferenceKey;
        }

        public String getBackgroundPreferenceKey() {
            return this.bgColor;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.preferenceKey == null ? 0 : this.preferenceKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            SH other = (SH)((Object)obj);
            return !(this.preferenceKey == null ? other.preferenceKey != null : !this.preferenceKey.equals(other.preferenceKey));
        }

        public String getDisplayName() {
            return this.description;
        }
    }
}

