/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.core.ValidatorRuntime;
import org.eclipse.dltk.validators.internal.core.ValidatorDefinitionsContainer;
import org.eclipse.dltk.validators.internal.ui.ValidatorMessages;
import org.eclipse.dltk.validators.internal.ui.ValidatorsUI;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ValidatorUpdater {
    public boolean updateValidatorSettings(IValidator[] validators) {
        ValidatorDefinitionsContainer container = new ValidatorDefinitionsContainer();
        container.addValidators(validators);
        this.saveValidatorDefinitions(container);
        return true;
    }

    private void saveValidatorDefinitions(ValidatorDefinitionsContainer container) {
        IRunnableWithProgress runnable = monitor -> {
            try {
                try {
                    monitor.beginTask(ValidatorMessages.ValidatorUpdater_0, 100);
                    String xml = container.getAsXML();
                    monitor.worked(40);
                    ValidatorRuntime.getPreferences().setValue("org.eclipse.dltk.validators.core.PREF_VALIDATOR_XML", xml);
                    monitor.worked(30);
                    ValidatorRuntime.savePreferences();
                    monitor.worked(30);
                }
                catch (IOException ioe) {
                    ValidatorsUI.log(ioe);
                    monitor.done();
                }
                catch (ParserConfigurationException e1) {
                    ValidatorsUI.log(e1);
                    monitor.done();
                }
                catch (TransformerException e2) {
                    ValidatorsUI.log(e2);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        };
        try {
            ValidatorsUI.getDefault().getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            ValidatorsUI.log(e);
        }
        catch (InterruptedException e) {
            ValidatorsUI.log(e);
        }
    }
}

