/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.WorkbenchStyledLabelProvider;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.commit.RepositoryCommitOpener;
import org.eclipse.egit.ui.internal.dialogs.SpellcheckableMessageArea;
import org.eclipse.egit.ui.internal.push.RefUpdateContentProvider;
import org.eclipse.egit.ui.internal.push.RefUpdateElement;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.model.IWorkbenchAdapter3;

class PushResultTable {
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";
    private static final String SASH_WEIGHTS_SETTING = "sashWeights";
    private final TreeViewer treeViewer;
    private final SashForm root;
    private final Image deleteImage;
    private ObjectReader reader;
    private Repository repo;
    private String hookResult;

    PushResultTable(Composite parent) {
        this(parent, null);
    }

    PushResultTable(Composite parent, final IDialogSettings dialogSettings) {
        this.root = new SashForm(parent, 512);
        Composite treeContainer = new Composite((Composite)this.root, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(treeContainer);
        this.treeViewer = new TreeViewer(treeContainer);
        this.treeViewer.setAutoExpandLevel(2);
        this.addToolbar(treeContainer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        Tree table = this.treeViewer.getTree();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        this.deleteImage = UIIcons.ELCL16_DELETE.createImage();
        UIUtils.hookDisposal((Widget)this.root, (Resource)this.deleteImage);
        this.root.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PushResultTable.saveDialogSettings(PushResultTable.this.root, dialogSettings);
                if (PushResultTable.this.reader != null) {
                    PushResultTable.this.reader.close();
                }
            }
        });
        this.treeViewer.setComparer(new IElementComparer(){

            public boolean equals(Object a, Object b) {
                return a == b;
            }

            public int hashCode(Object element) {
                return element.hashCode();
            }
        });
        WorkbenchStyledLabelProvider styleProvider = new WorkbenchStyledLabelProvider(){

            @Override
            public StyledString getStyledText(Object element) {
                if (element instanceof IWorkbenchAdapter3) {
                    return ((IWorkbenchAdapter3)element).getStyledText(element);
                }
                return super.getStyledText(element);
            }
        };
        this.treeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof RefUpdateElement && e2 instanceof RefUpdateElement) {
                    RefUpdateElement r1 = (RefUpdateElement)((Object)e1);
                    RefUpdateElement r2 = (RefUpdateElement)((Object)e2);
                    if (r1.isRejected() && !r2.isRejected()) {
                        return -1;
                    }
                    if (!r1.isRejected() && r2.isRejected()) {
                        return 1;
                    }
                    if (r1.isAdd() && !r2.isAdd()) {
                        return -1;
                    }
                    if (!r1.isAdd() && r2.isAdd()) {
                        return 1;
                    }
                    if (!r1.isTag() && r2.isTag()) {
                        return -1;
                    }
                    if (r1.isTag() && !r2.isTag()) {
                        return 1;
                    }
                    RemoteRefUpdate.Status s1 = r1.getStatus();
                    RemoteRefUpdate.Status s2 = r2.getStatus();
                    if (s1 != RemoteRefUpdate.Status.UP_TO_DATE && s2 == RemoteRefUpdate.Status.UP_TO_DATE) {
                        return -1;
                    }
                    if (s1 == RemoteRefUpdate.Status.UP_TO_DATE && s2 != RemoteRefUpdate.Status.UP_TO_DATE) {
                        return 1;
                    }
                    String ref1 = r1.getDstRefName();
                    String ref2 = r2.getDstRefName();
                    if (ref1 != null && ref2 != null) {
                        return ref1.compareToIgnoreCase(ref2);
                    }
                }
                if (e1 instanceof RepositoryCommit && e2 instanceof RepositoryCommit) {
                    return 0;
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)styleProvider));
        this.treeViewer.setContentProvider((IContentProvider)new RefUpdateContentProvider());
        Group messageGroup = new Group((Composite)this.root, 0);
        messageGroup.setText(UIText.PushResultTable_MessageText);
        GridLayoutFactory.swtDefaults().applyTo((Composite)messageGroup);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)messageGroup);
        final SpellcheckableMessageArea text = new SpellcheckableMessageArea((Composite)messageGroup, EMPTY_STRING, true, 2048){

            @Override
            protected void createMarginPainter() {
            }
        };
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)text);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    text.setText(PushResultTable.EMPTY_STRING);
                    return;
                }
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (structuredSelection.size() != 1) {
                    text.setText(PushResultTable.EMPTY_STRING);
                    return;
                }
                Object selected = structuredSelection.getFirstElement();
                if (selected instanceof RefUpdateElement) {
                    String toShow = PushResultTable.this.getResult((RefUpdateElement)((Object)selected));
                    if (!PushResultTable.this.hookResult.isEmpty()) {
                        toShow = String.valueOf(PushResultTable.this.hookResult) + toShow;
                    }
                    text.setText(toShow);
                }
            }
        });
        PushResultTable.initializeSashWeights(this.root, new int[]{3, 2}, dialogSettings);
        RepositoryCommitOpener.setup((StructuredViewer)this.treeViewer);
    }

    private void addToolbar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 512);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)toolbar);
        UIUtils.addExpansionItems(toolbar, (AbstractTreeViewer)this.treeViewer);
    }

    private String getResult(RefUpdateElement element) {
        StringBuilder result = new StringBuilder(EMPTY_STRING);
        PushOperationResult pushOperationResult = element.getPushOperationResult();
        URIish uri = element.getUri();
        result.append(UIText.PushResultTable_repository);
        result.append(SPACE);
        result.append(uri.toString());
        result.append(Text.DELIMITER);
        result.append(Text.DELIMITER);
        String message = element.getRemoteRefUpdate().getMessage();
        if (message != null) {
            result.append(message).append(Text.DELIMITER);
        }
        StringBuilder messagesBuffer = new StringBuilder(pushOperationResult.getPushResult(uri).getMessages());
        PushResultTable.trim(messagesBuffer);
        if (messagesBuffer.length() > 0) {
            result.append((CharSequence)messagesBuffer).append(Text.DELIMITER);
        }
        PushResultTable.trim(result);
        return result.toString();
    }

    private static void trim(StringBuilder s) {
        while (s.length() > 0 && (s.charAt(0) == '\n' || s.charAt(0) == '\r')) {
            s.deleteCharAt(0);
        }
        while (s.length() > 0 && (s.charAt(s.length() - 1) == '\n' || s.charAt(s.length() - 1) == '\r')) {
            s.deleteCharAt(s.length() - 1);
        }
    }

    private static void saveDialogSettings(SashForm sashForm, IDialogSettings dialogSettings) {
        if (dialogSettings != null) {
            int[] weights = sashForm.getWeights();
            String[] weightStrings = new String[weights.length];
            int i = 0;
            while (i < weights.length) {
                weightStrings[i] = String.valueOf(weights[i]);
                ++i;
            }
            dialogSettings.put(SASH_WEIGHTS_SETTING, weightStrings);
        }
    }

    private static void initializeSashWeights(SashForm sashForm, int[] defaultValues, IDialogSettings dialogSettings) {
        String[] weightStrings;
        if (dialogSettings != null && (weightStrings = dialogSettings.getArray(SASH_WEIGHTS_SETTING)) != null && weightStrings.length == defaultValues.length) {
            try {
                int[] weights = new int[weightStrings.length];
                int i = 0;
                while (i < weights.length) {
                    weights[i] = Integer.parseInt(weightStrings[i]);
                    ++i;
                }
                sashForm.setWeights(weights);
                return;
            }
            catch (NumberFormatException ignore) {
                dialogSettings.put(SASH_WEIGHTS_SETTING, null);
            }
        }
        sashForm.setWeights(defaultValues);
    }

    private String formatHookOutput(String hookOutput, String hookError) {
        String out = hookOutput.strip();
        String err = hookError.strip();
        if (out.isEmpty() && err.isEmpty()) {
            return EMPTY_STRING;
        }
        if (!out.isEmpty()) {
            out = this.prefixLines("stdout: ", out);
        }
        if (!err.isEmpty()) {
            err = this.prefixLines("stderr: ", err);
        }
        return MessageFormat.format(UIText.PushResultTable_PrePushHookOutput, out, err);
    }

    private String prefixLines(String prefix, String text) {
        return Stream.of(text.split("\n")).map(s -> String.valueOf(prefix) + s.stripTrailing()).collect(Collectors.joining("\n", EMPTY_STRING, "\n"));
    }

    void setData(Repository localDb, PushOperationResult result) {
        this.reader = localDb.newObjectReader();
        this.repo = localDb;
        this.treeViewer.setInput(null);
        if (result == null) {
            this.root.layout();
            return;
        }
        this.hookResult = this.formatHookOutput(result.getHookStdOut(), result.getHookStdErr()).replaceAll("\n", Text.DELIMITER);
        ArrayList<RefUpdateElement> results = new ArrayList<RefUpdateElement>();
        for (URIish uri : result.getURIs()) {
            if (!result.isSuccessfulConnection(uri)) continue;
            for (RemoteRefUpdate update : result.getPushResult(uri).getRemoteUpdates()) {
                results.add(new RefUpdateElement(result, update, uri, this.reader, this.repo));
            }
        }
        this.treeViewer.setInput((Object)results.toArray());
        Tree table = this.treeViewer.getTree();
        if (table.getItemCount() > 0) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(table.getItem(0).getData()));
        }
        this.root.layout();
    }

    Control getControl() {
        return this.root;
    }
}

