/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.staging.StagingEntry;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.swt.graphics.Rectangle;

class ConflictStateHoverManager
extends AbstractHoverInformationControlManager {
    private final TreeViewer viewer;

    protected ConflictStateHoverManager(TreeViewer viewer) {
        super(DefaultInformationControl::new);
        this.viewer = viewer;
        this.setAnchor(AbstractInformationControlManager.ANCHOR_BOTTOM);
    }

    protected void computeInformation() {
        StagingEntry entry;
        Object item;
        String information = null;
        ViewerCell cell = this.viewer.getCell(this.getHoverEventLocation());
        if (cell != null && (item = cell.getElement()) instanceof StagingEntry && (entry = (StagingEntry)item).hasConflicts()) {
            IndexDiff.StageState conflictType = entry.getConflictType();
            switch (conflictType) {
                case DELETED_BY_THEM: {
                    information = UIText.StagingView_Conflict_MD_long;
                    break;
                }
                case DELETED_BY_US: {
                    information = UIText.StagingView_Conflict_DM_long;
                    break;
                }
                case BOTH_MODIFIED: {
                    information = UIText.StagingView_Conflict_M_long;
                    break;
                }
                case BOTH_ADDED: {
                    information = UIText.StagingView_Conflict_A_long;
                    break;
                }
            }
            if (information != null) {
                Rectangle cellBounds = cell.getBounds();
                Rectangle bounds = this.viewer.getTree().getClientArea();
                bounds.y = cellBounds.y;
                bounds.height = cellBounds.height;
                int extra = entry.getExtraWidth();
                bounds.x = bounds.x + bounds.width - extra;
                bounds.width = extra;
                if (bounds.contains(this.getHoverEventLocation())) {
                    this.setInformation(information, bounds);
                    return;
                }
            }
        }
        this.setInformation(null, null);
    }
}

