/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.internal.codered.ui.perspectives;

import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.embedcdt.internal.codered.ui.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class CodeRedPerspectiveFactory
implements IPerspectiveFactory {
    public static final String ID = "org.eclipse.embedcdt.internal.codered.ui.perspectives.CodeRedPerspective";
    private static final String[] launchIds = new String[]{"ilg.gnumcueclipse.debug.gdbjtag.jlink.launchConfigurationType", "ilg.gnumcueclipse.debug.gdbjtag.qemu.launchConfigurationType", "ilg.gnumcueclipse.debug.gdbjtag.openocd.launchConfigurationType"};

    public CodeRedPerspectiveFactory() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("CodeRedPerspectiveFactory()");
        }
    }

    public void createInitialLayout(IPageLayout layout) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("CodeRedPerspectiveFactory.createInitialLayout()");
        }
        this.createLayout(layout);
        if (this.isDebugViewVisble()) {
            this.showView("org.eclipse.debug.ui.DebugView");
        }
    }

    private void createLayout(IPageLayout layout) {
        String editorId = layout.getEditorArea();
        IFolderLayout topLeftLayout = layout.createFolder("topLeft", 1, 0.33f, editorId);
        topLeftLayout.addView("org.eclipse.ui.navigator.ProjectExplorer");
        topLeftLayout.addPlaceholder("org.eclipse.cdt.ui.CView");
        topLeftLayout.addPlaceholder("org.eclipse.ui.views.BookmarkView");
        topLeftLayout.addView("org.eclipse.debug.ui.RegisterView");
        Bundle bundle = Platform.getBundle((String)"org.eclipse.embedcdt.debug.gdbjtag.ui");
        if (bundle != null) {
            topLeftLayout.addView("org.eclipse.embedcdt.internal.debug.gdbjtag.ui.views.PeripheralsView");
        }
        IFolderLayout bottomLeftLayout = layout.createFolder("bottomLeft", 4, 0.5f, "topLeft");
        bottomLeftLayout.addView("org.eclipse.debug.ui.VariableView");
        bottomLeftLayout.addView("org.eclipse.debug.ui.BreakpointView");
        bottomLeftLayout.addView("org.eclipse.ui.views.ContentOutline");
        bottomLeftLayout.addPlaceholder("org.eclipse.debug.ui.ExpressionView");
        IPlaceholderFolderLayout topLayout = layout.createPlaceholderFolder("top", 3, 0.175f, editorId);
        topLayout.addPlaceholder("org.eclipse.debug.ui.DebugView");
        IFolderLayout consoleLayout = layout.createFolder("consoleEtc", 4, 0.8f, editorId);
        consoleLayout.addView("org.eclipse.ui.console.ConsoleView");
        consoleLayout.addView("org.eclipse.ui.views.ProblemView");
        consoleLayout.addPlaceholder("org.eclipse.ui.views.ProgressView");
        consoleLayout.addView("org.eclipse.debug.ui.MemoryView");
        IFolderLayout bottomLayout = layout.createFolder("bottom", 4, 0.75f, editorId);
        IPlaceholderFolderLayout sideRightLayout = layout.createPlaceholderFolder("sideRight", 2, 0.66f, editorId);
        sideRightLayout.addPlaceholder("org.eclipse.cdt.dsf.debug.ui.disassembly.view");
    }

    private boolean isDebugViewVisble() {
        boolean bool = false;
        IWorkbenchPage[] pages = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
        int i = 0;
        while (i < pages.length) {
            IViewReference[] refs = pages[i].getViewReferences();
            int j = 0;
            while (j < refs.length) {
                if (Activator.getInstance().isDebugging()) {
                    System.out.println(refs[j].getId());
                }
                if ("org.eclipse.debug.ui.DebugView".equals(refs[j].getId())) {
                    bool = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return bool;
    }

    private void showView(final String id) {
        final IWorkbenchPage[] pages = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    pages[0].showView(id);
                }
                catch (Exception e) {
                    Activator.log((Throwable)e);
                }
            }
        });
    }

    private void setLaunchPerspective() {
        String[] ids = launchIds;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType[] types = launchManager.getLaunchConfigurationTypes();
        ArrayList<ILaunchConfigurationType> list = new ArrayList<ILaunchConfigurationType>();
        int i = 0;
        while (i < types.length) {
            String id = types[i].getIdentifier();
            int j = 0;
            while (j < ids.length) {
                if (id.equals(ids[j])) {
                    list.add(types[i]);
                }
                ++j;
            }
            ++i;
        }
        for (ILaunchConfigurationType type : list) {
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)type, (String)"debug", (String)ID);
        }
    }
}

