/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.lock;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.common.lock.CDOLockDelta;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.spi.common.lock.AbstractCDOLockState;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

public final class CDOLockStateImpl
extends AbstractCDOLockState {
    private static final Set<CDOLockOwner> NO_LOCK_OWNERS = Collections.emptySet();
    private static final Class<CDOLockOwner[]> ARRAY_CLASS = CDOLockOwner[].class;
    private Object readLockOwners;
    private CDOLockOwner writeLockOwner;
    private CDOLockOwner writeOptionOwner;

    public CDOLockStateImpl(Object lockedObject) {
        super(lockedObject);
    }

    @Override
    public Set<CDOLockOwner> getReadLockOwners() {
        if (this.readLockOwners == null) {
            return NO_LOCK_OWNERS;
        }
        if (this.readLockOwners.getClass() == ARRAY_CLASS) {
            CDOLockOwner[] owners = (CDOLockOwner[])this.readLockOwners;
            HashSet<CDOLockOwner> result = new HashSet<CDOLockOwner>();
            CDOLockOwner[] cDOLockOwnerArray = owners;
            int n = owners.length;
            int n2 = 0;
            while (n2 < n) {
                CDOLockOwner owner = cDOLockOwnerArray[n2];
                result.add(owner);
                ++n2;
            }
            return Collections.unmodifiableSet(result);
        }
        return Collections.singleton((CDOLockOwner)this.readLockOwners);
    }

    @Override
    public CDOLockOwner getWriteLockOwner() {
        return this.writeLockOwner;
    }

    @Override
    public CDOLockOwner getWriteOptionOwner() {
        return this.writeOptionOwner;
    }

    @Override
    public boolean isLocked(IRWLockManager.LockType type, CDOLockOwner by, boolean others) {
        if (type == null) {
            return this.isReadLocked(by, others) || this.isWriteLocked(by, others) || this.isOptionLocked(by, others);
        }
        switch (type) {
            case READ: {
                return this.isReadLocked(by, others);
            }
            case WRITE: {
                return this.isWriteLocked(by, others);
            }
            case OPTION: {
                return this.isOptionLocked(by, others);
            }
        }
        return false;
    }

    private boolean isReadLocked(CDOLockOwner by, boolean others) {
        boolean contained;
        int n;
        if (this.readLockOwners == null) {
            return false;
        }
        if (this.readLockOwners.getClass() == ARRAY_CLASS) {
            CDOLockOwner[] owners = (CDOLockOwner[])this.readLockOwners;
            n = owners.length;
            if (n == 0) {
                return false;
            }
            contained = CDOLockUtil.indexOf(owners, by) != -1;
        } else {
            n = 1;
            boolean bl = contained = this.readLockOwners == by;
        }
        if (others) {
            int ownCount;
            int n2 = ownCount = contained ? 1 : 0;
            return n > ownCount;
        }
        return contained;
    }

    private boolean isWriteLocked(CDOLockOwner by, boolean others) {
        if (this.writeLockOwner == null) {
            return false;
        }
        return this.writeLockOwner == by ^ others;
    }

    private boolean isOptionLocked(CDOLockOwner by, boolean others) {
        if (this.writeOptionOwner == null) {
            return false;
        }
        return this.writeOptionOwner == by ^ others;
    }

    @Override
    protected CDOLockDelta addReadOwner(CDOLockOwner owner) {
        if (this.readLockOwners == null) {
            this.readLockOwners = owner;
            return CDOLockUtil.createLockDelta(this.lockedObject, IRWLockManager.LockType.READ, null, owner);
        }
        if (this.readLockOwners.getClass() == ARRAY_CLASS) {
            CDOLockOwner[] owners = (CDOLockOwner[])this.readLockOwners;
            if (CDOLockUtil.indexOf(owners, owner) == -1) {
                int oldLength = owners.length;
                this.readLockOwners = new CDOLockOwner[oldLength + 1];
                System.arraycopy(owners, 0, this.readLockOwners, 0, oldLength);
                ((CDOLockOwner[])this.readLockOwners)[oldLength] = owner;
                return CDOLockUtil.createLockDelta(this.lockedObject, IRWLockManager.LockType.READ, null, owner);
            }
            return null;
        }
        if (this.readLockOwners != owner) {
            this.readLockOwners = new CDOLockOwner[]{(CDOLockOwner)this.readLockOwners, owner};
            return CDOLockUtil.createLockDelta(this.lockedObject, IRWLockManager.LockType.READ, null, owner);
        }
        return null;
    }

    @Override
    protected CDOLockDelta addWriteOwner(CDOLockOwner owner) {
        if (this.writeLockOwner == null) {
            this.writeLockOwner = owner;
            return CDOLockUtil.createLockDelta(this.lockedObject, IRWLockManager.LockType.WRITE, null, owner);
        }
        return null;
    }

    @Override
    protected CDOLockDelta addOptionOwner(CDOLockOwner owner) {
        if (this.writeOptionOwner == null) {
            this.writeOptionOwner = owner;
            return CDOLockUtil.createLockDelta(this.lockedObject, IRWLockManager.LockType.OPTION, null, owner);
        }
        return null;
    }

    @Override
    protected CDOLockDelta removeReadOwner(CDOLockOwner owner) {
        if (this.readLockOwners == null) {
            return null;
        }
        if (this.readLockOwners.getClass() == ARRAY_CLASS) {
            CDOLockOwner[] owners = (CDOLockOwner[])this.readLockOwners;
            int index = CDOLockUtil.indexOf(owners, owner);
            if (index != -1) {
                int rest;
                int oldLength = owners.length;
                this.readLockOwners = new CDOLockOwner[oldLength - 1];
                if (index > 0) {
                    System.arraycopy(owners, 0, this.readLockOwners, 0, index);
                }
                if ((rest = oldLength - index - 1) > 0) {
                    System.arraycopy(owners, index + 1, this.readLockOwners, index, rest);
                }
                return CDOLockUtil.createLockDelta(this.lockedObject, IRWLockManager.LockType.READ, owner, null);
            }
            return null;
        }
        if (this.readLockOwners == owner) {
            this.readLockOwners = null;
            return CDOLockUtil.createLockDelta(this.lockedObject, IRWLockManager.LockType.READ, owner, null);
        }
        return null;
    }

    @Override
    protected CDOLockDelta removeWriteOwner(CDOLockOwner owner) {
        if (this.writeLockOwner == owner) {
            this.writeLockOwner = null;
            return CDOLockUtil.createLockDelta(this.lockedObject, IRWLockManager.LockType.WRITE, owner, null);
        }
        return null;
    }

    @Override
    protected CDOLockDelta removeOptionOwner(CDOLockOwner owner) {
        if (this.writeOptionOwner == owner) {
            this.writeOptionOwner = null;
            return CDOLockUtil.createLockDelta(this.lockedObject, IRWLockManager.LockType.OPTION, owner, null);
        }
        return null;
    }

    @Override
    public CDOLockDelta[] remapOwner(CDOLockOwner oldOwner, CDOLockOwner newOwner) {
        List<CDOLockDelta> deltas = null;
        if (this.readLockOwners != null) {
            CDOLockOwner[] owners;
            int index;
            if (this.readLockOwners == oldOwner) {
                this.readLockOwners = newOwner;
                deltas = CDOLockUtil.appendLockDelta(deltas, this.lockedObject, IRWLockManager.LockType.READ, oldOwner, newOwner);
            } else if (this.readLockOwners.getClass() == ARRAY_CLASS && (index = CDOLockUtil.indexOf(owners = (CDOLockOwner[])this.readLockOwners, oldOwner)) != -1) {
                ((CDOLockOwner[])this.readLockOwners)[index] = newOwner;
                deltas = CDOLockUtil.appendLockDelta(deltas, this.lockedObject, IRWLockManager.LockType.READ, oldOwner, newOwner);
            }
        }
        if (this.writeLockOwner == oldOwner) {
            this.writeLockOwner = newOwner;
            deltas = CDOLockUtil.appendLockDelta(deltas, this.lockedObject, IRWLockManager.LockType.WRITE, oldOwner, newOwner);
        }
        if (this.writeOptionOwner == oldOwner) {
            this.writeOptionOwner = newOwner;
            deltas = CDOLockUtil.appendLockDelta(deltas, this.lockedObject, IRWLockManager.LockType.OPTION, oldOwner, newOwner);
        }
        return CDOLockUtil.toArray(deltas);
    }
}

