/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transfer.internal.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.spi.transfer.FileSystemTransferSystem;
import org.eclipse.emf.cdo.transfer.CDOTransferElement;
import org.eclipse.emf.cdo.transfer.CDOTransferSystem;
import org.eclipse.emf.cdo.transfer.spi.ui.TransferUIProvider;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;

public class FileSystemUIProvider
implements TransferUIProvider {
    @Override
    public ILabelProvider createLabelProvider(CDOTransferSystem system) {
        return new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof File) {
                    File file = (File)element;
                    if (file.isDirectory()) {
                        return SharedIcons.getImage((String)"obj16/CDOResourceFolder.gif");
                    }
                    return SharedIcons.getImage((String)"obj16/CDOFileResource.gif");
                }
                return super.getImage(element);
            }
        };
    }

    @Override
    public void addSupportedTransfers(List<Transfer> transfers) {
        transfers.add((Transfer)FileTransfer.getInstance());
    }

    @Override
    public List<CDOTransferElement> convertTransferData(Object data) {
        if (data instanceof String[]) {
            String[] paths = (String[])data;
            ArrayList<CDOTransferElement> result = new ArrayList<CDOTransferElement>(paths.length);
            int i = 0;
            while (i < paths.length) {
                String path = paths[i];
                CDOTransferElement element = FileSystemTransferSystem.INSTANCE.getElement(path);
                result.add(element);
                ++i;
            }
            return result;
        }
        return null;
    }

    @Override
    public CDOTransferElement convertTransferTarget(Object target) {
        return null;
    }

    @Override
    public Object convertSelection(IStructuredSelection selection) {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    extends TransferUIProvider.Factory {
        public Factory() {
            super("fs");
        }

        @Override
        public TransferUIProvider create(String description) throws ProductCreationException {
            return new FileSystemUIProvider();
        }
    }
}

