/**
 * Copyright (c) 2010 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.emf.codegen.ecore.xtext;


import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.generic.AbstractGenericResourceRuntimeModule;


/**
 * Default Guice bindings for managing GenModel resources in the context of Xtext.
 * 
 * @author Jan Koehnlein - Initial contribution and API
 */
public class GenModelRuntimeModule extends AbstractGenericResourceRuntimeModule
{
  @Override
  protected String getLanguageName()
  {
    return "org.eclipse.emf.codegen.ecore.genmodel.presentation.GenModelEditorID";
  }

  @Override
  protected String getFileExtensions()
  {
    return "genmodel";
  }

  public Class<? extends IDefaultResourceDescriptionStrategy> bindIDefaultResourceDescriptionStrategy()
  {
    return GenModelResourceDescriptionStrategy.class;
  }

  @Override
  public Class<? extends IQualifiedNameProvider> bindIQualifiedNameProvider()
  {
    return GenModelQualifiedNameProvider.class;
  }
}
