/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.presentation;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.emf.codegen.presentation.CodeGenUIPlugin;
import org.eclipse.emf.codegen.presentation.JETEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class JETActionBarContributor
extends TextEditorActionContributor {
    private final Map<String, RetargetTextEditorAction> selectionActions = new LinkedHashMap<String, RetargetTextEditorAction>();
    private final RetargetTextEditorAction toggleInsertModeAction;
    private final RetargetTextEditorAction gotoMatchingBracketAction;
    private final RetargetTextEditorAction selectEncodingJETElement;
    private final RetargetTextEditorAction extractLocalVariableAction;
    private final RetargetTextEditorAction renameLocalVariableAction;
    private final RetargetTextEditorAction formatAction;

    public JETActionBarContributor() {
        ResourceBundle bundle = CodeGenUIPlugin.getResourceBundle();
        for (Map.Entry<String, String> entry : JETEditor.JavaEditor.SELECTION_ACTIONS.entrySet()) {
            RetargetTextEditorAction retargetTextEditorAction = new RetargetTextEditorAction(bundle, String.valueOf(entry.getKey()) + ".");
            retargetTextEditorAction.setActionDefinitionId(entry.getValue());
            this.selectionActions.put(entry.getKey(), retargetTextEditorAction);
        }
        this.toggleInsertModeAction = new RetargetTextEditorAction(bundle, "ToggleInsertMode.", 2);
        this.toggleInsertModeAction.setActionDefinitionId("org.eclipse.ui.edit.text.toggleInsertMode");
        this.gotoMatchingBracketAction = new RetargetTextEditorAction(bundle, "GotoMatchingBracket.");
        this.gotoMatchingBracketAction.setActionDefinitionId("org.eclipse.emf.codegen.ui.jet.goto.matching.bracket");
        this.selectEncodingJETElement = new RetargetTextEditorAction(bundle, "SelectEnclosingJETElement.");
        this.selectEncodingJETElement.setActionDefinitionId("org.eclipse.emf.codegen.ui.jet.select.enclosing");
        this.extractLocalVariableAction = new RetargetTextEditorAction(bundle, "ExtractLocalVariable.");
        this.extractLocalVariableAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.extract.local.variable");
        this.renameLocalVariableAction = new RetargetTextEditorAction(bundle, "Rename.");
        this.renameLocalVariableAction.setActionDefinitionId("org.eclipse.codegen.ui.jet.rename");
        this.formatAction = new RetargetTextEditorAction(bundle, "Format.");
        this.formatAction.setActionDefinitionId("org.eclipse.codegen.ui.jet.format");
    }

    public void contributeToMenu(IMenuManager menu) {
        super.contributeToMenu(menu);
        IMenuManager editMenu = menu.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.appendToGroup("additions", (IAction)this.toggleInsertModeAction);
            editMenu.appendToGroup("additions", (IAction)this.gotoMatchingBracketAction);
            MenuManager expandSelectionToMenu = new MenuManager("Expand Selection to", "expandSelection");
            editMenu.insertAfter(ITextEditorActionConstants.SELECT_ALL, (IContributionItem)expandSelectionToMenu);
            expandSelectionToMenu.add((IAction)this.selectEncodingJETElement);
            for (Map.Entry<String, String> entry : JETEditor.JavaEditor.SELECTION_ACTIONS.entrySet()) {
                expandSelectionToMenu.add((IAction)this.selectionActions.get(entry.getKey()));
            }
        }
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        if (part instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)part;
            IAction toggleInsertAction = textEditor.getAction("TOGGLE_INSERT_MODE");
            this.toggleInsertModeAction.setAction(toggleInsertAction);
        }
        if (part instanceof JETEditor) {
            JETEditor jetEditor = (JETEditor)part;
            JETEditor.JavaEditor javaEditor = jetEditor.getJavaEditor();
            IActionBars actionBars = this.getActionBars();
            for (Map.Entry<String, String> entry : JETEditor.JavaEditor.SELECTION_ACTIONS.entrySet()) {
                String actionID = entry.getKey();
                IAction action = javaEditor.getAction(actionID);
                RetargetTextEditorAction retargetTextEditorSelectionAction = this.selectionActions.get(actionID);
                retargetTextEditorSelectionAction.setAction(action);
                actionBars.setGlobalActionHandler(entry.getValue(), (IAction)retargetTextEditorSelectionAction);
            }
            IAction selectEncosingJETElementAction = jetEditor.getAction("SelectEnclosingJETElement");
            selectEncosingJETElementAction.setActionDefinitionId("org.eclipse.emf.codegen.ui.jet.select.enclosing");
            actionBars.setGlobalActionHandler("org.eclipse.emf.codegen.ui.jet.select.enclosing", selectEncosingJETElementAction);
            IAction openDeclarationAction = javaEditor.getOpenDeclarationAction();
            openDeclarationAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
            actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.edit.text.java.open.editor", openDeclarationAction);
            IAction gotoMatchingBracketAction = javaEditor.getGotoMatchingBracketAction();
            gotoMatchingBracketAction.setActionDefinitionId("org.eclipse.emf.codegen.ui.jet.goto.matching.bracket");
            this.gotoMatchingBracketAction.setAction(gotoMatchingBracketAction);
            actionBars.setGlobalActionHandler("org.eclipse.emf.codegen.ui.jet.goto.matching.bracket", (IAction)this.gotoMatchingBracketAction);
            IAction extractLocalVariableAction = javaEditor.getAction("ExtractLocalVariable");
            this.extractLocalVariableAction.setAction(extractLocalVariableAction);
            actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.edit.text.java.extract.local.variable", (IAction)this.extractLocalVariableAction);
            IAction renameLocalVariableAction = jetEditor.getAction("Rename");
            this.renameLocalVariableAction.setAction(renameLocalVariableAction);
            actionBars.setGlobalActionHandler("Rename", (IAction)this.renameLocalVariableAction);
            IAction formatAction = jetEditor.getAction("Format");
            this.formatAction.setAction(formatAction);
            actionBars.setGlobalActionHandler("Format", (IAction)this.formatAction);
        }
    }
}

