/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JPatternDictionary;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.FacadeVisitor;
import org.eclipse.emf.codegen.merge.java.facade.JAbstractType;
import org.eclipse.emf.codegen.merge.java.facade.JAnnotation;
import org.eclipse.emf.codegen.merge.java.facade.JCompilationUnit;
import org.eclipse.emf.codegen.merge.java.facade.JImport;
import org.eclipse.emf.codegen.merge.java.facade.JMember;
import org.eclipse.emf.codegen.merge.java.facade.JMethod;
import org.eclipse.emf.codegen.merge.java.facade.JNode;
import org.eclipse.emf.codegen.merge.java.facade.JPackage;
import org.eclipse.emf.codegen.merge.java.facade.NodeConverter;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTFacadeHelper;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMerger {
    public static final boolean DEBUG = false;
    public static final String DEFAULT_FACADE_HELPER_CLASS = ASTFacadeHelper.class.getName();
    protected static final Object[] NO_ARGUMENTS = new Object[0];
    protected static Pattern interfaceBracePattern = null;
    protected JControlModel controlModel;
    protected JCompilationUnit sourceCompilationUnit;
    protected JCompilationUnit targetCompilationUnit;
    protected JPatternDictionary sourcePatternDictionary;
    protected JPatternDictionary targetPatternDictionary;
    protected Map<JNode, JNode> sourceToTargetMap = new LinkedHashMap<JNode, JNode>();
    protected Map<JNode, JNode> targetToSourceMap = new LinkedHashMap<JNode, JNode>();
    protected Map<JNode, List<JNode>> orderedSourceChildrenMap = new HashMap<JNode, List<JNode>>();
    protected boolean fixInterfaceBrace;
    protected boolean isBlocked = false;
    protected boolean targetCompilationUnitExists;
    protected boolean targetCompilationChanged = false;
    protected boolean noAbstractTypeConversion = true;
    private boolean clean = "true".equals(System.getProperty("org.eclipse.emf.codegen.merge.java.JMerger.clean"));

    public JMerger() {
    }

    public JMerger(JControlModel controlModel) {
        this();
        this.controlModel = controlModel;
        this.setFixInterfaceBrace(this.getControlModel().getFacadeHelper().fixInterfaceBrace());
    }

    public void reset() {
        if (this.sourcePatternDictionary != null) {
            this.sourcePatternDictionary.reset();
            this.sourcePatternDictionary = null;
        }
        if (this.targetPatternDictionary != null) {
            this.targetPatternDictionary.reset();
            this.targetPatternDictionary = null;
        }
        this.sourceCompilationUnit = null;
        this.targetCompilationUnit = null;
        this.sourceToTargetMap.clear();
        this.targetToSourceMap.clear();
        this.orderedSourceChildrenMap.clear();
        this.isBlocked = false;
        this.targetCompilationChanged = false;
    }

    public void merge() {
        this.targetCompilationChanged = false;
        boolean bl = this.targetCompilationUnitExists = this.targetCompilationUnit != null;
        if (this.targetCompilationUnitExists && this.clean) {
            this.sourceCompilationUnit.setHeader(this.targetCompilationUnit.getHeader());
            this.targetCompilationUnit = this.sourceCompilationUnit;
            this.targetCompilationChanged = true;
        } else {
            this.pullTargetCompilationUnit();
            if (!this.isBlocked && this.targetCompilationUnitExists) {
                this.pushSourceCompilationUnit();
                this.sweepTargetCompilationUnit();
                this.sortTargetCompilationUnit();
            }
        }
    }

    public void remerge() {
        this.sourceToTargetMap.clear();
        this.targetToSourceMap.clear();
        this.orderedSourceChildrenMap.clear();
        this.isBlocked = false;
        this.merge();
    }

    public JCompilationUnit createCompilationUnitForInputStream(InputStream inputStream) {
        return this.createCompilationUnitForInputStream(inputStream, null);
    }

    public JCompilationUnit createCompilationUnitForInputStream(InputStream inputStream, String encoding) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] input = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(input);
            bufferedInputStream.close();
            return this.getControlModel().getFacadeHelper().createCompilationUnit("NAME", encoding == null ? new String(input) : new String(input, encoding));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public JCompilationUnit createCompilationUnitForURI(String uri) {
        return this.createCompilationUnitForURI(uri, null);
    }

    public JCompilationUnit createCompilationUnitForURI(String uri, String encoding) {
        try {
            URL url = null;
            try {
                url = new URL(uri);
            }
            catch (MalformedURLException exception) {
                url = new URL("file:" + uri);
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(url.openStream());
            byte[] input = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(input);
            bufferedInputStream.close();
            return this.getControlModel().getFacadeHelper().createCompilationUnit(url.toString(), encoding == null ? new String(input) : new String(input, encoding));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public JCompilationUnit createCompilationUnitForContents(String contents) {
        return this.getControlModel().getFacadeHelper().createCompilationUnit("NAME", contents);
    }

    public JControlModel getControlModel() {
        return this.controlModel;
    }

    public JCompilationUnit getSourceCompilationUnit() {
        return this.sourceCompilationUnit;
    }

    public void setSourceCompilationUnit(String sourceCompilationUnitContents) {
        this.setSourceCompilationUnit(this.createCompilationUnitForContents(sourceCompilationUnitContents));
    }

    public void setSourceCompilationUnit(JCompilationUnit sourceCompilationUnit) {
        this.sourceCompilationUnit = sourceCompilationUnit;
        this.sourcePatternDictionary = new JPatternDictionary(sourceCompilationUnit, this.getControlModel());
    }

    public String getSourceCompilationUnitContents() {
        return this.sourceCompilationUnit.getContents();
    }

    public JCompilationUnit getTargetCompilationUnit() {
        return this.targetCompilationUnit;
    }

    public void setTargetCompilationUnit(JCompilationUnit targetCompilationUnit) {
        this.targetCompilationUnit = targetCompilationUnit;
        this.targetPatternDictionary = new JPatternDictionary(targetCompilationUnit, this.getControlModel());
    }

    public String getTargetCompilationUnitContents() {
        String result = null;
        if (!(this.getControlModel().getFacadeHelper() == null || this.targetCompilationUnitExists && this.targetCompilationChanged)) {
            result = this.getControlModel().getFacadeHelper().getOriginalContents(this.targetCompilationUnit);
        }
        if (result == null) {
            result = this.targetCompilationUnit.getContents();
            if (this.clean) {
                result = CodeGenUtil.convertFormat(this.controlModel.getLeadingTabReplacement(), this.controlModel.convertToStandardBraceStyle(), result);
            }
        }
        if (this.fixInterfaceBrace) {
            if (interfaceBracePattern == null) {
                interfaceBracePattern = Pattern.compile("(?:\\n\\r|\\r\\n|\\n|\\r)(\\s*)(?:public|private|protected|static|\\s)*(?:interface|class)\\s*[^\\{\\n\\r]*(\\{)(\\n\\r|\\r\\n|\\n|\\r)", 8);
            }
            Matcher matcher = interfaceBracePattern.matcher(result);
            int offset = 0;
            while (matcher.find()) {
                if (this.getControlModel().standardBraceStyle) {
                    if (result.charAt(matcher.start(2) - 1) == ' ') continue;
                    result = String.valueOf(result.substring(0, offset + matcher.start(2))) + " {" + result.substring(offset + matcher.end(2), result.length());
                    ++offset;
                    continue;
                }
                result = String.valueOf(result.substring(0, offset + matcher.start(2))) + matcher.group(3) + matcher.group(1) + "{" + result.substring(offset + matcher.end(2), result.length());
                offset += matcher.group(1).length() + matcher.group(3).length();
            }
        }
        return result;
    }

    public JPatternDictionary getSourcePatternDictionary() {
        return this.sourcePatternDictionary;
    }

    public void setSourcePatternDictionary(JPatternDictionary sourcePatternDictionary) {
        this.sourcePatternDictionary = sourcePatternDictionary;
    }

    public JPatternDictionary getTargetPatternDictionary() {
        return this.targetPatternDictionary;
    }

    public void setTargetPatternDictionary(JPatternDictionary targetPatternDictionary) {
        this.targetPatternDictionary = targetPatternDictionary;
    }

    public boolean isFixInterfaceBrace() {
        return this.fixInterfaceBrace;
    }

    public void setFixInterfaceBrace(boolean fixInterfaceBrace) {
        this.fixInterfaceBrace = fixInterfaceBrace;
    }

    protected void pullTargetCompilationUnit() {
        if (!this.targetCompilationUnitExists) {
            this.setTargetCompilationUnit((JCompilationUnit)this.insertClone(this.sourceCompilationUnit));
        } else {
            this.map(this.sourceCompilationUnit, this.targetCompilationUnit);
            this.applyPullRules(this.sourceCompilationUnit, this.targetCompilationUnit);
            this.createPullTargetVisitor().start(this.targetCompilationUnit);
        }
    }

    protected FacadeVisitor createPullTargetVisitor() {
        return new PullTargetVisitor();
    }

    protected void pushSourceCompilationUnit() {
        this.createPushSourceVisitor().start(this.sourceCompilationUnit);
    }

    protected FacadeVisitor createPushSourceVisitor() {
        return new PushSourceVisitor();
    }

    protected void sortTargetCompilationUnit() {
        FacadeHelper facadeHelper = this.getControlModel().getFacadeHelper();
        JNode parent = null;
        List children = null;
        for (List<JNode> nodes : this.orderedSourceChildrenMap.values()) {
            if (nodes.size() < 2) continue;
            Iterator<JNode> i = nodes.iterator();
            JNode sourceNode = i.next();
            JNode previousTargetNode = this.sourceToTargetMap.get(sourceNode);
            do {
                sourceNode = i.next();
                JNode nextTargetNode = this.sourceToTargetMap.get(sourceNode);
                boolean reorder = true;
                JNode nextTargetNodeParent = nextTargetNode.getParent();
                if (facadeHelper.isSibilingTraversalExpensive() && parent != nextTargetNodeParent) {
                    parent = nextTargetNodeParent;
                    children = nextTargetNodeParent == null ? null : new ArrayList<JNode>(nextTargetNodeParent.getChildren());
                }
                int previousTargetNodeIndex = 0;
                int nextTargetNodeIndex = 0;
                if (children != null) {
                    previousTargetNodeIndex = children.indexOf(previousTargetNode);
                    reorder = previousTargetNodeIndex > (nextTargetNodeIndex = children.indexOf(nextTargetNode));
                } else {
                    JNode node = facadeHelper.getPrevious(nextTargetNode);
                    while (node != null) {
                        if (node == previousTargetNode) {
                            reorder = false;
                            break;
                        }
                        node = facadeHelper.getPrevious(node);
                    }
                }
                if (reorder) {
                    this.targetCompilationChanged = true;
                    facadeHelper.remove(nextTargetNode);
                    boolean appendNode = false;
                    if (children != null) {
                        children.remove(nextTargetNode);
                        boolean bl = appendNode = children.get(children.size() - 1) == previousTargetNode;
                        if (appendNode) {
                            children.add(nextTargetNode);
                        } else {
                            children.add(previousTargetNodeIndex, nextTargetNode);
                        }
                    } else {
                        boolean bl = appendNode = facadeHelper.getNext(previousTargetNode) == null;
                    }
                    if (appendNode) {
                        facadeHelper.addChild(previousTargetNode.getParent(), nextTargetNode);
                    } else {
                        facadeHelper.insertSibling(previousTargetNode, nextTargetNode, false);
                    }
                }
                previousTargetNode = nextTargetNode;
            } while (i.hasNext());
        }
    }

    protected void sweepTargetCompilationUnit() {
        HashSet<JNode> sweptNodes = new HashSet<JNode>(this.targetToSourceMap.size());
        for (Map.Entry<JNode, JNode> entry : this.targetToSourceMap.entrySet()) {
            if (entry.getValue() != null) continue;
            JNode node = entry.getKey();
            JNode parent = node.getParent();
            if (parent != null && sweptNodes.contains(parent)) {
                sweptNodes.add(node);
                continue;
            }
            if (!this.applySweepRules(node)) continue;
            this.targetCompilationChanged = true;
            sweptNodes.add(node);
        }
    }

    private int getStartIndex(String string) {
        int index = string.indexOf("<!--");
        if (index > 0) {
            while (Character.isWhitespace(string.charAt(--index)) && index > 0) {
            }
            return index;
        }
        return 0;
    }

    protected void applyPullRules(JNode sourceNode, JNode targetNode) {
        try {
            for (JControlModel.PullRule pullRule : this.getControlModel().getPullRules()) {
                if (pullRule.getSourceGetFeature().getFeatureMethod() == null || !pullRule.getSourceGetFeature().getFeatureClass().isInstance(sourceNode) || pullRule.getTargetPutFeature().getFeatureMethod() == null || !pullRule.getTargetPutFeature().getFeatureClass().isInstance(targetNode) || !this.sourcePatternDictionary.isMarkedUp(pullRule.getSourceMarkup(), pullRule.getSourceParentMarkup(), sourceNode) || !this.targetPatternDictionary.isMarkedUp(pullRule.getTargetMarkup(), pullRule.getTargetParentMarkup(), targetNode)) continue;
                if (pullRule.getEqualityFeature() != null) {
                    Method equalityFeatureMethod = pullRule.getEqualityFeature().getFeatureMethod();
                    Object value1 = equalityFeatureMethod.invoke((Object)sourceNode, NO_ARGUMENTS);
                    Object value2 = equalityFeatureMethod.invoke((Object)targetNode, NO_ARGUMENTS);
                    if (value1 == null ? value2 != null : !value1.equals(value2)) continue;
                }
                Method sourceGetMethod = pullRule.getSourceGetFeature().getFeatureMethod();
                Object value = sourceGetMethod.invoke((Object)sourceNode, NO_ARGUMENTS);
                Method targetPutMethod = pullRule.getTargetPutFeature().getFeatureMethod();
                if (!sourceGetMethod.getReturnType().isArray() || targetPutMethod.getParameterTypes()[0].isAssignableFrom(sourceGetMethod.getReturnType())) {
                    Object[] targetParameterTypes;
                    if (value instanceof String) {
                        String oldStringValue;
                        String stringValue = (String)value;
                        stringValue = this.getControlModel().getFacadeHelper().applyFormatRules(stringValue);
                        Pattern sourceTransfer = pullRule.getSourceTransfer();
                        if (sourceTransfer != null && (oldStringValue = (String)sourceGetMethod.invoke((Object)targetNode, NO_ARGUMENTS)) != null) {
                            Matcher sourceMatcher = sourceTransfer.matcher(stringValue);
                            Matcher targetMatcher = sourceTransfer.matcher(oldStringValue);
                            if (sourceMatcher.groupCount() >= 1 && targetMatcher.groupCount() >= 1) {
                                StringBuilder result = new StringBuilder();
                                int index = 0;
                                int sourceStart = 0;
                                int targetStart = 0;
                                if (sourceTransfer.pattern().startsWith("(\\s*<!--")) {
                                    sourceStart = this.getStartIndex(stringValue);
                                    targetStart = this.getStartIndex(oldStringValue);
                                }
                                boolean match = sourceMatcher.find(sourceStart) && targetMatcher.find(targetStart);
                                while (match) {
                                    result.append(stringValue.substring(index, sourceMatcher.start(1)));
                                    result.append(targetMatcher.group(1));
                                    index = sourceMatcher.end(1);
                                    boolean bl = match = sourceMatcher.find() && targetMatcher.find();
                                }
                                if (result.length() == 0) {
                                    stringValue = null;
                                } else {
                                    result.append(stringValue.substring(index));
                                    stringValue = result.toString();
                                }
                            } else {
                                stringValue = null;
                            }
                        }
                        value = stringValue;
                    }
                    if (value == null && !targetPutMethod.getName().equals("setInitializer") && !targetPutMethod.getName().equals("setSuperclass") && !targetPutMethod.getName().equals("setExceptions")) continue;
                    Object oldValue = sourceGetMethod.invoke((Object)targetNode, NO_ARGUMENTS);
                    if (value != null ? value.equals(oldValue) : oldValue == null) continue;
                    if (value instanceof Object[] && oldValue instanceof Object[] && Arrays.equals((Object[])value, (Object[])oldValue) || targetPutMethod.getName().equals("setSuperclass") && oldValue != null && value != null && ((String)oldValue).trim().equals(((String)value).trim()) || sourceGetMethod.getName().equals("getReturnType") && this.getControlModel().getBlockPattern() != null && ((JMethod)targetNode).getComment() != null && this.getControlModel().getBlockPattern().matcher(((JMethod)targetNode).getComment()).find()) continue;
                    targetPutMethod.invoke((Object)targetNode, value);
                    this.targetCompilationChanged = true;
                    if (!targetPutMethod.getName().equals("setBody") || !(sourceNode instanceof JMethod)) continue;
                    JMethod sourceMethod = (JMethod)sourceNode;
                    JMethod targetMethod = (JMethod)targetNode;
                    Object[] sourceParameterTypes = sourceMethod.getParameterTypes();
                    if (Arrays.equals(sourceParameterTypes, targetParameterTypes = targetMethod.getParameterTypes())) {
                        targetMethod.setParameterNames(sourceMethod.getParameterNames());
                        continue;
                    }
                    targetMethod.setParameters(sourceMethod.getParameters());
                    continue;
                }
                ArrayList<String> additionalStrings = new ArrayList<String>();
                String[] sourceStrings = (String[])value;
                if (sourceStrings != null) {
                    additionalStrings.addAll(Arrays.asList(sourceStrings));
                }
                if (targetPutMethod.getName().equals("addSuperInterface")) {
                    Pattern sourceTransfer = pullRule.getSourceTransfer();
                    String comment = ((JMember)targetNode).getComment();
                    if (sourceTransfer != null && comment != null) {
                        Matcher matcher = sourceTransfer.matcher(comment);
                        while (matcher.find() && matcher.groupCount() >= 1) {
                            String clientStrings = comment.substring(matcher.start(matcher.groupCount()), matcher.end(matcher.groupCount()));
                            StringTokenizer stringTokenizer = new StringTokenizer(clientStrings, ", \t\n\r\f");
                            while (stringTokenizer.hasMoreTokens()) {
                                String token = stringTokenizer.nextToken();
                                if (additionalStrings.contains(token)) continue;
                                additionalStrings.add(token);
                            }
                        }
                    }
                    Object[] oldSuperInterfaces = (String[])sourceGetMethod.invoke((Object)targetNode, new Object[0]);
                    Object[] superInterfaces = additionalStrings.toArray(new String[additionalStrings.size()]);
                    if (!(oldSuperInterfaces == null ? superInterfaces.length != 0 : !Arrays.equals(oldSuperInterfaces, superInterfaces))) continue;
                    Method putMethod = targetNode.getClass().getMethod("setSuperInterfaces", String[].class);
                    putMethod.invoke((Object)targetNode, new Object[]{superInterfaces});
                    this.targetCompilationChanged = true;
                    continue;
                }
                String[] oldStringValues = (String[])sourceGetMethod.invoke((Object)targetNode, NO_ARGUMENTS);
                List<Object> old = oldStringValues == null ? Collections.emptyList() : Arrays.asList(oldStringValues);
                for (String string : additionalStrings) {
                    if (old.contains(string)) continue;
                    targetPutMethod.invoke((Object)targetNode, string);
                    this.targetCompilationChanged = true;
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected void applySortRules(JNode sourceNode) {
        for (JControlModel.SortRule sortRule : this.getControlModel().getSortRules()) {
            if (!this.sourcePatternDictionary.isMarkedUp(sortRule.getMarkup(), sourceNode) || !sortRule.getSelector().isInstance(sourceNode)) continue;
            JNode parent = sourceNode.getParent();
            List<JNode> children = this.orderedSourceChildrenMap.get(parent);
            if (children == null) {
                children = new ArrayList<JNode>();
                this.orderedSourceChildrenMap.put(parent, children);
            }
            children.add(sourceNode);
            break;
        }
    }

    protected boolean applySweepRules(JNode targetNode) {
        for (JControlModel.SweepRule sweepRule : this.getControlModel().getSweepRules()) {
            boolean sweep;
            boolean bl = sweep = sweepRule.getSelector() == JImport.class && targetNode instanceof JImport && sweepRule.getMarkup().matcher(targetNode.getName()).find() || sweepRule.getSelector().isInstance(targetNode) && this.targetPatternDictionary.isMarkedUp(sweepRule.getMarkup(), sweepRule.getParentMarkup(), targetNode);
            if (!sweep) continue;
            switch (sweepRule.getAction()) {
                case REMOVE: {
                    this.getControlModel().getFacadeHelper().remove(targetNode);
                    return true;
                }
                case RENAME: {
                    String newName = sweepRule.getNewName();
                    int index = newName.indexOf("{0}");
                    if (index >= 0) {
                        String name = targetNode.getName();
                        newName = String.valueOf(newName.substring(0, index)) + name + newName.substring(index + "{0}".length());
                    }
                    targetNode.setName(newName);
                    return true;
                }
                case COMMENT: {
                    this.getControlModel().getFacadeHelper().commentOut(targetNode);
                    return true;
                }
            }
            break;
        }
        return false;
    }

    protected boolean areCompatible(JNode sourceNode, JNode targetNode) {
        return targetNode != null && targetNode.getClass().isInstance(sourceNode);
    }

    protected JNode convertTarget(JAbstractType targetAbstractType, Class<? extends JAbstractType> sourceClass) {
        NodeConverter converter = this.getControlModel().getFacadeHelper().getNodeConverter();
        if (converter != null) {
            this.noAbstractTypeConversion = false;
            return converter.convert(targetAbstractType, sourceClass);
        }
        return null;
    }

    protected JNode insertClone(JNode sourceNode) {
        JNode targetParent;
        JNode sourceParent;
        String originalContents;
        FacadeHelper facadeHelper = this.getControlModel().getFacadeHelper();
        if (sourceNode == this.sourceCompilationUnit && !this.targetCompilationUnitExists && (originalContents = facadeHelper.getOriginalContents(this.sourceCompilationUnit)) != null) {
            return this.createCompilationUnitForContents(facadeHelper.applyFormatRules(originalContents));
        }
        Object context = this.targetCompilationUnit != null ? facadeHelper.getContext(this.targetCompilationUnit) : null;
        JNode targetNode = facadeHelper.cloneNode(context, sourceNode);
        if (targetNode != null) {
            this.mapChildren(sourceNode, targetNode);
        }
        if ((sourceParent = sourceNode.getParent()) != null && (targetParent = this.sourceToTargetMap.get(sourceParent)) != null) {
            this.targetCompilationChanged = true;
            JNode targetParentFirstChild = null;
            if (facadeHelper.isSibilingTraversalExpensive()) {
                List<JNode> sourceChildren = sourceParent.getChildren();
                List<JNode> targetChildren = targetParent.getChildren();
                int i = sourceChildren.indexOf(sourceNode);
                while (i >= 0) {
                    JNode previousNode;
                    JNode targetSibling;
                    if (i > 0 && (targetSibling = this.sourceToTargetMap.get(previousNode = sourceChildren.get(i - 1))) != null) {
                        int targetSibilingIndex = targetChildren.indexOf(targetSibling);
                        if (targetSibilingIndex == targetChildren.size() - 1) {
                            facadeHelper.addChild(targetSibling.getParent(), targetNode);
                        } else {
                            facadeHelper.insertSibling(targetChildren.get(targetSibilingIndex + 1), targetNode, true);
                        }
                        return targetNode;
                    }
                    --i;
                }
                targetParentFirstChild = targetChildren.isEmpty() ? null : targetChildren.get(0);
            } else {
                JNode previousNode = facadeHelper.getPrevious(sourceNode);
                while (previousNode != null) {
                    JNode targetSibling = this.sourceToTargetMap.get(previousNode);
                    if (targetSibling != null) {
                        JNode targetNextSibling = facadeHelper.getNext(targetSibling);
                        if (targetNextSibling == null) {
                            facadeHelper.addChild(targetSibling.getParent(), targetNode);
                        } else {
                            facadeHelper.insertSibling(targetNextSibling, targetNode, true);
                        }
                        return targetNode;
                    }
                    previousNode = facadeHelper.getPrevious(previousNode);
                }
                targetParentFirstChild = facadeHelper.getFirstChild(targetParent);
            }
            if (targetParentFirstChild == null) {
                facadeHelper.addChild(targetParent, targetNode);
            } else {
                facadeHelper.insertSibling(targetParentFirstChild, targetNode, true);
            }
        }
        return targetNode;
    }

    protected boolean isPushMarkedUp(JNode node) {
        JMethod sourceMethod;
        JNode sourceParent = node.getParent();
        JNode targetParent = this.sourceToTargetMap.get(sourceParent);
        assert (targetParent != null);
        String redirect = this.getControlModel().getRedirect();
        if (redirect != null && node instanceof JAnnotation && sourceParent instanceof JMethod && !(sourceMethod = (JMethod)sourceParent).isConstructor() && !sourceMethod.getName().endsWith(redirect) && targetParent instanceof JMethod && ((JMethod)targetParent).getName().endsWith(redirect)) {
            return false;
        }
        boolean markedUp = true;
        for (JControlModel.PushRule rule : this.getControlModel().getPushRules()) {
            if (!rule.getSelector().isInstance(node)) continue;
            Pattern targetParentMarkup = rule.getTargetParentMarkup();
            Pattern sourceMarkup = rule.getMarkup();
            if (this.getSourcePatternDictionary().isMarkedUp(sourceMarkup, node) && this.getTargetPatternDictionary().isMarkedUp(targetParentMarkup, targetParent)) {
                return true;
            }
            markedUp = false;
        }
        return markedUp;
    }

    protected void map(JNode sourceNode, JNode targetNode) {
        if (sourceNode != null) {
            this.sourceToTargetMap.put(sourceNode, targetNode);
        }
        this.targetToSourceMap.put(targetNode, sourceNode);
    }

    protected void mapChildren(JNode sourceNode, JNode targetNode) {
        block6: {
            FacadeHelper facadeHelper;
            block5: {
                this.map(sourceNode, targetNode);
                facadeHelper = this.getControlModel().getFacadeHelper();
                if (!facadeHelper.isSibilingTraversalExpensive()) break block5;
                if (sourceNode == null) break block6;
                List<JNode> sourceChildren = sourceNode.getChildren();
                if (targetNode == null) {
                    int i = 0;
                    int size = sourceChildren.size();
                    while (i < size) {
                        this.mapChildren(sourceChildren.get(i), null);
                        ++i;
                    }
                } else {
                    List<JNode> targetChildren = targetNode.getChildren();
                    int targetChildrenSize = targetChildren.size();
                    int i = 0;
                    int size = sourceChildren.size();
                    while (i < size) {
                        this.mapChildren(sourceChildren.get(i), targetChildrenSize > i ? targetChildren.get(i) : null);
                        ++i;
                    }
                }
                break block6;
            }
            JNode sourceChild = facadeHelper.getFirstChild(sourceNode);
            JNode targetChild = facadeHelper.getFirstChild(targetNode);
            while (sourceChild != null) {
                this.mapChildren(sourceChild, targetChild);
                sourceChild = facadeHelper.getNext(sourceChild);
                targetChild = facadeHelper.getNext(targetChild);
            }
        }
    }

    public Object run(Object object) {
        try {
            String contents = this.execute((Monitor)new BasicMonitor(), (String[])object);
            System.out.println("**********************************************");
            System.out.println(contents);
            return 0;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public String execute(Monitor monitor, String[] arguments) {
        String mergeXML = arguments[0];
        String sourceURI = arguments[1];
        String targetURI = arguments[2];
        String facadeHelperClass = arguments.length > 3 ? arguments[3] : DEFAULT_FACADE_HELPER_CLASS;
        this.controlModel = new JControlModel();
        this.controlModel.initialize(CodeGenUtil.instantiateFacadeHelper(facadeHelperClass), mergeXML);
        this.sourceCompilationUnit = this.createCompilationUnitForURI(sourceURI);
        this.targetCompilationUnit = this.createCompilationUnitForURI(targetURI);
        this.sourcePatternDictionary = new JPatternDictionary(this.sourceCompilationUnit, this.getControlModel());
        this.targetPatternDictionary = new JPatternDictionary(this.targetCompilationUnit, this.getControlModel());
        this.merge();
        String contents = this.getTargetCompilationUnitContents();
        if (this.controlModel.getFacadeHelper() != null) {
            this.controlModel.getFacadeHelper().reset();
        }
        return contents;
    }

    public class PullTargetVisitor
    extends FacadeVisitor {
        protected void doPull(JNode source, JNode target) {
            JMerger.this.map(source, target);
            if (source != null) {
                JMerger.this.applyPullRules(source, target);
            }
        }

        protected void visit(JNode target) {
            if (target instanceof JAbstractType) {
                JAbstractType targetAbstractType = (JAbstractType)target;
                String comment = targetAbstractType.getComment();
                JMerger.this.isBlocked = targetAbstractType.getParent() instanceof JCompilationUnit && JMerger.this.getControlModel().getBlockPattern() != null && comment != null && JMerger.this.getControlModel().getBlockPattern().matcher(comment).find();
                String nodeIdentifier = JMerger.this.targetPatternDictionary.getNodeIdentifier(targetAbstractType);
                JAbstractType sourceAbstractType = JMerger.this.sourcePatternDictionary.getAbstractTypeMap().get(nodeIdentifier);
                if (sourceAbstractType != null && !JMerger.this.areCompatible(sourceAbstractType, targetAbstractType)) {
                    JNode newTarget = JMerger.this.convertTarget(targetAbstractType, sourceAbstractType.getClass());
                    if (newTarget != null) {
                        target = newTarget;
                        JMerger.this.targetPatternDictionary.start(target);
                    } else if (!JMerger.this.isBlocked) {
                        JMerger.this.map(sourceAbstractType, target);
                    }
                }
            }
            if (!JMerger.this.isBlocked) {
                super.visit(target);
            }
        }

        protected boolean basicVisit(JNode node) {
            String nodeIdentifier = JMerger.this.targetPatternDictionary.getNodeIdentifier(node);
            JNode sourceNode = JMerger.this.sourcePatternDictionary.getNodeMap(node).get(nodeIdentifier);
            if (JMerger.this.noAbstractTypeConversion && sourceNode == null) {
                sourceNode = JMerger.this.sourcePatternDictionary.getNode(nodeIdentifier);
            }
            this.doPull(sourceNode, node);
            return true;
        }

        protected boolean visit(JCompilationUnit compilationUnit) {
            return true;
        }

        protected boolean visit(JMethod method) {
            String nodeIdentifier = JMerger.this.targetPatternDictionary.getNodeIdentifier(method);
            JNode sourceNode = JMerger.this.sourcePatternDictionary.getMethodMap().get(nodeIdentifier);
            if (sourceNode == null && JMerger.this.getControlModel().getRedirect() != null && method.getName() != null && method.getName().endsWith(JMerger.this.getControlModel().getRedirect())) {
                String qualifiedTargetMethodName = method.getQualifiedName();
                int index = qualifiedTargetMethodName.indexOf("(");
                qualifiedTargetMethodName = String.valueOf(qualifiedTargetMethodName.substring(0, index - JMerger.this.getControlModel().getRedirect().length())) + qualifiedTargetMethodName.substring(index);
                sourceNode = JMerger.this.sourcePatternDictionary.getMethodMap().get(qualifiedTargetMethodName);
            }
            if (JMerger.this.noAbstractTypeConversion && sourceNode == null) {
                sourceNode = JMerger.this.sourcePatternDictionary.getNode(nodeIdentifier);
            }
            this.doPull(sourceNode, method);
            return true;
        }

        protected boolean visit(JPackage jPackage) {
            JPackage sourcePackage = JMerger.this.sourcePatternDictionary.getJPackage();
            this.doPull(sourcePackage, jPackage);
            return false;
        }
    }

    public class PushSourceVisitor
    extends FacadeVisitor {
        protected boolean doPush(JNode sourceNode) {
            JMerger.this.applySortRules(sourceNode);
            if (!JMerger.this.sourceToTargetMap.containsKey(sourceNode)) {
                if (JMerger.this.isPushMarkedUp(sourceNode)) {
                    JMerger.this.insertClone(sourceNode);
                }
                return false;
            }
            return true;
        }

        protected boolean basicVisit(JNode node) {
            return this.doPush(node);
        }

        protected boolean visit(JCompilationUnit compilationUnit) {
            return true;
        }

        protected boolean visit(JAbstractType abstractType) {
            return super.visit(abstractType) && JMerger.this.areCompatible(abstractType, JMerger.this.sourceToTargetMap.get(abstractType));
        }

        protected boolean visit(JImport jImport) {
            return !JMerger.this.targetPatternDictionary.isNoImport(jImport) && super.visit(jImport);
        }
    }
}

