/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java.facade;

public final class FacadeFlags {
    public static final int DEFAULT = 0;
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICTFP = 2048;
    public static final int SUPER = 32;
    public static final int SYNTHETIC = 4096;
    public static final int DEPRECATED = 0x100000;
    public static final int BRIDGE = 64;
    public static final int VARARGS = 128;
    public static final int ENUM = 16384;
    public static final int ANNOTATION = 8192;

    private FacadeFlags() {
    }

    public static boolean isAbstract(int flags) {
        return (flags & 0x400) != 0;
    }

    public static boolean isDeprecated(int flags) {
        return (flags & 0x100000) != 0;
    }

    public static boolean isFinal(int flags) {
        return (flags & 0x10) != 0;
    }

    public static boolean isInterface(int flags) {
        return (flags & 0x200) != 0;
    }

    public static boolean isNative(int flags) {
        return (flags & 0x100) != 0;
    }

    public static boolean isPrivate(int flags) {
        return (flags & 2) != 0;
    }

    public static boolean isProtected(int flags) {
        return (flags & 4) != 0;
    }

    public static boolean isPublic(int flags) {
        return (flags & 1) != 0;
    }

    public static boolean isStatic(int flags) {
        return (flags & 8) != 0;
    }

    public static boolean isStrictfp(int flags) {
        return (flags & 0x800) != 0;
    }

    public static boolean isSynchronized(int flags) {
        return (flags & 0x20) != 0;
    }

    public static boolean isSynthetic(int flags) {
        return (flags & 0x1000) != 0;
    }

    public static boolean isTransient(int flags) {
        return (flags & 0x80) != 0;
    }

    public static boolean isVolatile(int flags) {
        return (flags & 0x40) != 0;
    }

    public static boolean isBridge(int flags) {
        return (flags & 0x40) != 0;
    }

    public static boolean isVarargs(int flags) {
        return (flags & 0x80) != 0;
    }

    public static boolean isEnum(int flags) {
        return (flags & 0x4000) != 0;
    }

    public static boolean isAnnotation(int flags) {
        return (flags & 0x2000) != 0;
    }

    public static String toString(int flags) {
        int len;
        StringBuilder sb = new StringBuilder();
        if (FacadeFlags.isPublic(flags)) {
            sb.append("public ");
        }
        if (FacadeFlags.isProtected(flags)) {
            sb.append("protected ");
        }
        if (FacadeFlags.isPrivate(flags)) {
            sb.append("private ");
        }
        if (FacadeFlags.isStatic(flags)) {
            sb.append("static ");
        }
        if (FacadeFlags.isAbstract(flags)) {
            sb.append("abstract ");
        }
        if (FacadeFlags.isFinal(flags)) {
            sb.append("final ");
        }
        if (FacadeFlags.isNative(flags)) {
            sb.append("native ");
        }
        if (FacadeFlags.isSynchronized(flags)) {
            sb.append("synchronized ");
        }
        if (FacadeFlags.isTransient(flags)) {
            sb.append("transient ");
        }
        if (FacadeFlags.isVolatile(flags)) {
            sb.append("volatile ");
        }
        if (FacadeFlags.isStrictfp(flags)) {
            sb.append("strictfp ");
        }
        if ((len = sb.length()) == 0) {
            return "";
        }
        sb.setLength(len - 1);
        return sb.toString();
    }
}

