/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import java.util.Set;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.ColorChangeEvent;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.CompareColorImpl;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.themes.ITheme;

public class EMFCompareColor
extends CompareColorImpl {
    private final IPropertyChangeListener fThemeChangeListener;
    private final EventBus eventBus;
    private final ITheme theme;
    private static final Set<String> COLOR_IDS = ImmutableSet.of((Object)"org.eclipse.emf.compare.unmergeableChangeColor", (Object)"org.eclipse.emf.compare.unmergeableChangeColor", (Object)"org.eclipse.emf.compare.incomingChangeColor", (Object)"org.eclipse.emf.compare.requiredChangeColor", (Object)"org.eclipse.emf.compare.conflictingChangeColor", (Object)"org.eclipse.emf.compare.outgoingChangeColor", (Object[])new String[0]);

    public EMFCompareColor(Display display, boolean leftIsLocal, ITheme theme, EventBus eventBus) {
        super(display, leftIsLocal, theme != null ? theme.getColorRegistry() : JFaceResources.getColorRegistry());
        this.eventBus = eventBus;
        this.theme = theme;
        this.fThemeChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                EMFCompareColor.this.handlePropertyChangeEvent(event);
            }
        };
        if (theme != null) {
            theme.addPropertyChangeListener(this.fThemeChangeListener);
        }
    }

    public void dispose() {
        if (this.theme != null) {
            this.theme.removePropertyChangeListener(this.fThemeChangeListener);
        }
        super.dispose();
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent event) {
        String propertyKey = event.getProperty();
        if (COLOR_IDS.contains(propertyKey)) {
            this.updateColors();
            if (this.eventBus != null) {
                ColorChangeEvent colorEvent = new ColorChangeEvent(propertyKey);
                this.eventBus.post((Object)colorEvent);
            }
        }
    }
}

