/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.base.Preconditions;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.compare.rcp.EMFCompareLogger;

public class DiagnosticSupport {
    private final BasicDiagnostic diagnostic;
    private static final EMFCompareLogger LOGGER = new EMFCompareLogger(DiagnosticSupport.class);

    public DiagnosticSupport(BasicDiagnostic diagnostic) {
        this.diagnostic = (BasicDiagnostic)Preconditions.checkNotNull((Object)diagnostic);
    }

    public DiagnosticSupport() {
        this.diagnostic = this.createDiagnostic();
    }

    public BasicDiagnostic getDiagnostic() {
        return this.diagnostic;
    }

    protected BasicDiagnostic createDiagnostic() {
        return new BasicDiagnostic("org.eclipse.emf.compare.ide.ui", 0, null, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(Diagnostic resourceDiagnostic) {
        BasicDiagnostic basicDiagnostic = this.diagnostic;
        synchronized (basicDiagnostic) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Merging diagnostic #" + this.diagnostic.getChildren().size());
            }
            this.diagnostic.merge(resourceDiagnostic);
        }
    }
}

